/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.analysis.ml.prediction.ModelDataUtilsService;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.PivotTablesService;
import com.dataiku.dip.pivot.backend.dss.LinoUtils;
import com.dataiku.dip.pivot.backend.dss.ShakerToLino;
import com.dataiku.dip.pivot.backend.dss.aggregators.LinoColumnFactory;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.ColumnSummary;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.SampleBuilder;
import com.dataiku.dip.shaker.TableToSchema;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SQLNotebooksDataService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ModelDataUtilsService modelDataUtilsService;
    @Autowired
    private LinoUtils linoUtils;
    private static final TypeInferrer2 inferrer = new TypeInferrer2();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.notebooks.sql.data");

    public FutureResponse<PivotTablesService.Response> getPivotResponse_NT(AuthCtx user, PivotTableRequest request, QueryFullIdentifier qfi) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        logger.info((Object)"Lookup cache");
        File cacheFolder = this.sqlNotebooksDAO.resultChartsCacheFolder(qfi.projectKey(), qfi.notebookId(), qfi.qid());
        try (LinoReader cacheReader = LinoUtils.getCachedReader(cacheFolder, request);){
            if (request instanceof PivotTableTensorRequest) {
                for (AxisDef axis : ((PivotTableTensorRequest)request).axes) {
                    Preconditions.checkNotNull((Object)axis);
                }
            }
            FilterUtils.expandRelativeDateFilters(request);
            if (cacheReader != null) {
                logger.info((Object)"Got cache, start execution");
                FutureResponse fr = new FutureResponse();
                fr.hasResult = true;
                fr.result = new PivotTablesService.Response();
                ((PivotTablesService.Response)fr.result).updatedSampleId = "anysample";
                ((PivotTablesService.Response)fr.result).pivotResponse = LinoUtils.fromLino(request, cacheReader, this.variablesService.getForProject(qfi.projectKey()));
                FutureResponse futureResponse = fr;
                return futureResponse;
            }
            SQLPivotResponseFutureThread sqlPivotResponseFutureThread = new SQLPivotResponseFutureThread(user, request, qfi);
            FutureResponse<PivotTablesService.Response> futureResponse = this.futureService.runFuture(sqlPivotResponseFutureThread, 2000L, new TypeToken<FutureResponse<PivotTablesService.Response>>(){});
            return futureResponse;
        }
    }

    public DataService.ColumnDetailedAnalysis getDetailedColumnAnalysis(QueryFullIdentifier qfi, SerializedShakerScript ss, String column, int alphanumMaxResults) throws Exception {
        MemTable table = this.getUnfilteredTableWithReportForQueryResult((QueryFullIdentifier)qfi).table;
        return this.modelDataUtilsService.getDetailedColumnAnalysis(table, ss, column, alphanumMaxResults);
    }

    public MemScriptRunner.TableWithReport getTableWithReportForQueryResult(QueryFullIdentifier qfi, FilterRequest filterRequest, SerializedShakerScript sss) throws Exception {
        MemScriptRunner.TableWithReport twr = this.getUnfilteredTableWithReportForQueryResult(qfi);
        this.modelDataUtilsService.applyFiltersAndSorts(twr, filterRequest, sss.sorting);
        return twr;
    }

    public MemScriptRunner.TableWithReport getUnfilteredTableWithReportForQueryResult(QueryFullIdentifier qfi) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Computing", (double)4.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            long before = System.currentTimeMillis();
            MemScriptRunner.TableWithReport ret = new MemScriptRunner.TableWithReport();
            WarningsContext warningsContext = new WarningsContext();
            String sampleId = qfi.projectKey();
            File sampleFile = this.sqlNotebooksDAO.resultSampleFile(qfi.projectKey(), qfi.notebookId(), qfi.qid());
            SampleBuilder.SampleMeta sampleToRead = SampleBuilder.getSampleMetaFromSampleFile(sampleFile, sampleId);
            QueryRunResult queryRunResult = this.sqlNotebooksDAO.readResult(qfi.projectKey(), qfi.notebookId(), qfi.qid());
            if (queryRunResult == null || !queryRunResult.success) {
                throw new IllegalArgumentException("No result for query " + qfi.qid + " in notebook " + qfi.notebookId + " in project " + qfi.projectKey + ".");
            }
            Schema schema = this.buildSchemaFromResultColumns(queryRunResult);
            FutureProgress.updateState((double)1.0);
            if (sampleToRead != null) {
                logger.info((Object)"Sample cached on disk");
            } else {
                logger.info((Object)"Sample not cached on disk, computing it");
                try (FutureProgress.AutocloseableFutureProgressState buildingState = FutureProgress.pushAutoCloseableState((String)"Building sample");){
                    MemTable memTable = this.queryResultToMemTable(queryRunResult);
                    SampleBuilder.writeResultSample(sampleFile, memTable);
                }
                sampleToRead = SampleBuilder.getSampleMetaFromSampleFile(sampleFile, sampleId);
            }
            assert (sampleToRead != null);
            FutureProgress.updateState((double)2.0);
            logger.info((Object)"Reading sample");
            ret.usedSample = sampleToRead;
            try (FutureProgress.AutocloseableFutureProgressState readingState = FutureProgress.pushAutoCloseableState((String)"Reading sample");){
                ret.table = SampleBuilder.readSample(sampleFile);
                ret.initialRows = ret.table.nrows();
                ret.initialCols = ret.table.ncols();
                logger.info((Object)("Reading sample done, read " + ret.table.nrows() + " rows"));
            }
            FutureProgress.updateState((double)3.0);
            ret.table.compact();
            FutureProgress.updateState((double)4.0);
            logger.info((Object)("Serialized warnings " + String.valueOf(warningsContext) + " -> " + JSON.json((Object)warningsContext.getOutput())));
            ret.warnings = warningsContext.getOutput();
            try (FutureProgress.AutocloseableFutureProgressState inferringState = FutureProgress.pushAutoCloseableState((String)"Detecting types");){
                inferrer.processForExplore(qfi.toString(), ret.table, schema);
            }
            FutureProgress.updateState((double)5.0);
            long inferDone = System.currentTimeMillis();
            logger.info((Object)("Table report done time =  " + (inferDone - before)));
            MemScriptRunner.TableWithReport tableWithReport = ret;
            return tableWithReport;
        }
    }

    private Schema buildSchemaFromResultColumns(QueryRunResult queryRunResult) {
        Schema schema = new Schema();
        for (QueryRunResult.ScriptRunResultColumn col : queryRunResult.columns) {
            SchemaColumn newSchemaColumn = new SchemaColumn(col.name, col.dssType);
            newSchemaColumn.withOriginalSQLType(col.type);
            schema.addColumn(newSchemaColumn);
        }
        return schema;
    }

    private MemTable queryResultToMemTable(QueryRunResult queryRunResult) {
        MemTable memTable = new MemTable();
        if (!queryRunResult.hasResultset) {
            return memTable;
        }
        MemColumn[] memTableColumns = new MemColumn[queryRunResult.columns.size()];
        for (int i = 0; i < queryRunResult.columns.size(); ++i) {
            QueryRunResult.ScriptRunResultColumn col = queryRunResult.columns.get(i);
            memTableColumns[i] = memTable.column(col.name);
        }
        for (String[] row : queryRunResult.rows) {
            Row tableRow = memTable.row();
            for (int i = 0; i < row.length; ++i) {
                String cellValue = row[i];
                tableRow.put((Column)memTableColumns[i], cellValue);
            }
            memTable.appendRow(tableRow);
        }
        return memTable;
    }

    public ColumnSummary getColumnSummary_NT(QueryFullIdentifier qfi) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        ColumnSummary ret = new ColumnSummary();
        ret.requiredSampleId = qfi.qid();
        MemScriptRunner.TableWithReport twr = this.getUnfilteredTableWithReportForQueryResult(qfi);
        this.linoUtils.fillUsableColumns(twr.table, ret);
        return ret;
    }

    public LinoColumnFactory getColumnsFactory(QueryFullIdentifier qfi) throws IOException {
        File cacheFolder = this.sqlNotebooksDAO.resultChartsCacheFolder(qfi.projectKey(), qfi.notebookId(), qfi.qid());
        try (LinoReader cacheReader = LinoUtils.getCachedReader(cacheFolder, null);){
            if (cacheReader != null) {
                LinoColumnFactory linoColumnFactory = new LinoColumnFactory(cacheReader);
                return linoColumnFactory;
            }
        }
        return null;
    }

    public record QueryFullIdentifier(String projectKey, String notebookId, String qid) {
    }

    private class SQLPivotResponseFutureThread
    extends SimpleFutureThread<PivotTablesService.Response> {
        private final PivotTableRequest request;
        private final QueryFullIdentifier qfi;
        private final FuturePayload payload;

        public SQLPivotResponseFutureThread(AuthCtx owner, PivotTableRequest pivotTableRequest, QueryFullIdentifier qfi) throws Exception {
            super(owner);
            this.request = pivotTableRequest;
            this.payload = SQLPivotResponseFutureThread.buildPayload(qfi);
            this.qfi = qfi;
        }

        private static FuturePayload buildPayload(QueryFullIdentifier qfi) {
            FuturePayload fp = new FuturePayload();
            fp.action = "refresh_scatterplot";
            fp.targets.add(DSSFuturePayloadUtils.forSQLNotebook(qfi.projectKey, qfi.notebookId).withPart("prediction_plot"));
            fp.displayName = "Refreshing predicted values plot";
            return fp;
        }

        @Override
        protected PivotTablesService.Response compute() throws Exception {
            MemScriptRunner.TableWithReport twr = SQLNotebooksDataService.this.getUnfilteredTableWithReportForQueryResult(this.qfi);
            Schema schema = TableToSchema.inferSchemaSimple(twr.table, false);
            LinoUtils.checkAllColumns(schema.getColumns(), this.request);
            List<SchemaColumn> linoableColumns = LinoUtils.getLinoableColumns(twr.table);
            if (this.request == null || LinoUtils.allColumnsAreLinoable(linoableColumns, this.request)) {
                logger.info((Object)"Will build and use a cache, computing new hash");
                File cacheFolder = SQLNotebooksDataService.this.sqlNotebooksDAO.resultChartsCacheFolder(this.qfi.projectKey(), this.qfi.notebookId(), this.qfi.qid());
                DKUFileUtils.mkdirs((File)cacheFolder);
                try (FutureProgress.AutocloseableFutureProgressState buildState = FutureProgress.pushAutoCloseableState((String)"Building cache");){
                    ShakerToLino.fromPredictedMemTable(twr.table, cacheFolder, "cache", linoableColumns, 50000);
                }
                try (LinoReader reader = new LinoReader(cacheFolder, "cache");){
                    PivotTablesService.Response r = new PivotTablesService.Response();
                    r.pivotResponse = LinoUtils.fromLino(this.request, reader, SQLNotebooksDataService.this.variablesService.getForProject(this.qfi.projectKey()));
                    r.updatedSampleId = this.qfi.qid();
                    PivotTablesService.Response response = r;
                    return response;
                }
            }
            throw new NotImplementedException();
        }

        public FuturePayload getPayload() {
            return this.payload;
        }
    }
}

