/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.DateRelativeFilterHelper;
import com.dataiku.dip.shaker.filter.DisplayFilterColumn;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInterval;
import java.util.Objects;

public class DateRelativeFilter
extends DisplayFilterColumn {
    private final ChartFilter.DateFilterPart part;
    private final ChartFilter.DateRelativeOption option;
    private final AnyTemporal anyTemporalType = new AnyTemporal();
    private final Boolean includeEmptyValues;
    @VisibleForTesting
    DateTime nowForTests;
    private final ReadableInterval bounds;

    public DateRelativeFilter(String column, ChartFilter.DateFilterPart part, ChartFilter.DateRelativeOption option, DateTime now, Boolean includeEmptyValues) {
        this.column = column;
        this.option = option;
        this.part = part;
        this.bounds = option != null && part != null && option.isEffective() ? DateRelativeFilterHelper.computeInterval(part, option, (ReadableInstant)now) : null;
        this.includeEmptyValues = includeEmptyValues;
    }

    public DateRelativeFilter(String column, ChartFilter.DateFilterPart part, ChartFilter.DateRelativeOption option, Boolean includeEmptyValues) {
        this(column, part, option, new DateTime().withZone(DateTimeZone.UTC), includeEmptyValues);
    }

    @Override
    public boolean filterRow(MemRow row, Column cd) {
        String val = row.get(cd);
        if (val == null || val.isEmpty()) {
            return Objects.requireNonNullElse(this.includeEmptyValues, false);
        }
        if (this.option == null || this.bounds == null) {
            return true;
        }
        long timestamp = this.anyTemporalType.msSinceEpoch(val);
        return DateRelativeFilter.matchCell(timestamp, this.bounds);
    }

    public static boolean matchCell(long timestamp, ReadableInterval bounds) {
        return timestamp >= bounds.getStartMillis() && timestamp <= bounds.getEndMillis();
    }
}

