/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl.formats;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.custom.CustomJavaFormatMeta;
import com.dataiku.dip.formats.custom.CustomJavaFormatParams;
import com.dataiku.dip.formats.custom.CustomJavaOutputFormatter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.shaker.mrimpl.formats.CustomJavaFormatDependenciesHandler;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class CustomJavaFormatOutputAdapter
extends FileOutputFormat<Void, RowWithFactories> {
    private final CustomJavaFormatParams formatParams;
    private final String formatType;
    private final Schema outputSchema;
    private final WarningsContext warningsContext;
    private final String projectKey;

    public CustomJavaFormatOutputAdapter(DatasetConfig outputConf, WarningsContext warningsContext) {
        this.formatType = outputConf.dataset.formatType;
        this.projectKey = outputConf.dataset.getProjectKey();
        this.formatParams = (CustomJavaFormatParams)outputConf.dataset.getFormatParams();
        this.outputSchema = outputConf.dataset.getSchema();
        this.warningsContext = (WarningsContext)Preconditions.checkNotNull((Object)warningsContext);
    }

    public static void registerDependencies(AuthCtx authCtx, Dataset dataset, List<SimpleKeyValue> configKeys, List<File> resourceJars) throws IOException, DKUSecurityException {
        CustomJavaFormatDependenciesHandler.registerDependencies(authCtx, ".output", dataset, configKeys, resourceJars);
    }

    public static void loadDependencies(Configuration hadoopConf) throws IOException {
        CustomJavaFormatDependenciesHandler.loadDependencies(".output", hadoopConf);
    }

    public RecordWriter<Void, RowWithFactories> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        CustomJavaFormatMeta formatMeta = (CustomJavaFormatMeta)FormatFactory.getMeta(this.formatType);
        CustomJavaOutputFormatter outputFormatter = (CustomJavaOutputFormatter)formatMeta.buildFormatter(DSSAuthCtx.newNone(), this.projectKey, this.formatParams);
        outputFormatter.setOutputSchema(this.outputSchema);
        outputFormatter.setWarningsContext(this.warningsContext);
        Path file = this.getDefaultWorkFile(taskAttemptContext, "bin");
        FileSystem fs = file.getFileSystem(taskAttemptContext.getConfiguration());
        FSDataOutputStream dataOutputStream = fs.create(file, false);
        return new InternalRecordWriter(outputFormatter, dataOutputStream);
    }

    private class InternalRecordWriter
    extends RecordWriter<Void, RowWithFactories> {
        private final CustomJavaOutputFormatter outputFormatter;
        private final FSDataOutputStream dataOutputStream;
        private ColumnFactory cf;
        private OutputStream os;

        public InternalRecordWriter(CustomJavaOutputFormatter outputFormatter, FSDataOutputStream dataOutputStream) {
            this.outputFormatter = outputFormatter;
            this.dataOutputStream = dataOutputStream;
        }

        private void lazyInit(RowWithFactories firstRow) throws IOException, InterruptedException {
            if (this.cf == null) {
                this.cf = firstRow == null ? new StreamColumnFactory() : firstRow.getColumnFactory();
                this.os = this.dataOutputStream.getWrappedStream();
                try {
                    this.outputFormatter.header(this.cf, this.os);
                }
                catch (Exception e) {
                    throw new IOException("Formatting error", e);
                }
            }
        }

        public void write(Void aVoid, RowWithFactories mrRow) throws IOException, InterruptedException {
            this.lazyInit(mrRow);
            try {
                this.outputFormatter.format(mrRow.getRow(), this.cf, this.os);
            }
            catch (Exception e) {
                throw new IOException("Formatting error", e);
            }
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            this.lazyInit(null);
            try {
                this.outputFormatter.footer(this.cf, this.os);
            }
            catch (Exception e) {
                throw new IOException("Formatting error", e);
            }
            finally {
                this.os.close();
                this.dataOutputStream.close();
            }
        }
    }
}

