/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.expr;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.ExpressionError;
import com.dataiku.dip.expressions.GrelToQueryMapping;
import com.dataiku.dip.expressions.GrelToQueryTranslator;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.model.StepParamsWithVariablesContext;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.expr.PreviousRowsBuffer;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CreateColumnWithGREL {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "CreateColumnWithGREL";
        }

        @Override
        public String getDocPage() {
            return "formula";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CUSTOM, ProcessorTag.MATH, ProcessorTag.STRING});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.CreateColumnWithGREL.HELP", "This processor computes new columns using formulas based on other columns (like in a spreadsheet).\nThe formula language provides:\n\n* Math functions\n* String manipulation functions\n* Date handling functions\n* Boolean and conditional expressions for rules creation\n\n# Usage examples\n* Compute a numerical expression: `(col1 + col2) / 2 * log(col3)`\n* Manipulate strings : `toLowercase(substring(strip(MyText), 0, 7))`\n* Create a rule-based column: `if (width > height, \"wide\", \"tall\")`\n\n# Getting help\nThe formula editor provides live syntax checking and preview, complete language reference and examples.\n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withCustomForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.CreateColumnWithGREL.DESCRIPTION", "Formula")).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.COLUMN", "Column")).withMNESParam("expression", this.translate(language, "SHAKER.PROCESSOR.CreateColumnWithGREL.DESCRIPTION.FORMULA", "Formula")).withHiddenDescription("GREL formula");
        }

        @Override
        public StreamImpl build(Parameter param) {
            return new StreamImpl(param);
        }

        @Override
        protected Object selfReport(Parameter param) {
            JsonObject o = new JsonObject();
            o.addProperty("formulaLength", (Number)StringUtils.defaultIfBlank((String)param.expression, (String)"").length());
            o.addProperty("withErrorColumn", Boolean.valueOf(StringUtils.isNotBlank((String)param.errorColumn)));
            if (param.forcedCast != null && param.forcedCast.getType() != null) {
                o.addProperty("forcedCastType", param.forcedCast.getType().getName());
            }
            return o;
        }

        @Override
        public StepParams expandParams(StepParams params, VariablesContext vc) {
            Parameter grelParams = (Parameter)params;
            grelParams.expression = vc.expand(grelParams.expression);
            grelParams.variablesContext = vc;
            return grelParams;
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return this.getCapabilities(sp, report, dialect, null, null);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect, AbstractSQLConnection conn, Dataset dataset) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            Parameter grelParams = (Parameter)sp;
            if (StringUtils.isNotBlank((String)grelParams.forcedSQLTranslation)) {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
                ret.withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL);
            } else {
                if (StringUtils.isNotBlank((String)grelParams.errorColumn)) {
                    ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: the error column is not supported in SQL");
                    ret.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, "Cannot use optimized engine: the error column is not supported with native Spark");
                    return ret;
                }
                Expression expr = new Expression(grelParams.expression, null, null, null, true, true);
                expr.setVariablesContext(grelParams.variablesContext);
                if (expr.requirePreviousRows()) {
                    ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: the formula needs row buffering which is not available with SQL");
                    ret.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, "Cannot use optimized engine: the formula needs row buffering which is not available with native Spark");
                    return ret;
                }
                GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping(dialect), dataset != null ? dataset.getSchema() : null);
                try {
                    GrelTranslator.TranslationResult<String> tr = translator.translateToString(expr, false);
                    if (tr.isFullyTranslated) {
                        ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
                        ret.withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL);
                    } else {
                        ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: the formula is not fully translatable to SQL");
                        ret.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, "Cannot use optimized engine: the formula is not fully translatable to native Spark");
                    }
                }
                catch (Exception e) {
                    ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: the formula is not fully translatable to SQL: " + e.getMessage());
                    ret.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, "Cannot use optimized engine: the formula is not fully translatable to native spark: " + e.getMessage());
                }
            }
            return ret;
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.expr.CreateColumnWithGRELNS";
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                Parameter formulaParams = (Parameter)pss.params;
                Expression expression = new Expression(formulaParams.expression, null, null, null, true);
                List<String> formulaInputColumns = expression.getVariables();
                boolean outputColumnInInput = formulaInputColumns.contains(formulaParams.column);
                if (!outputColumnInInput) {
                    updatedDatasetPairLineage.removeRelationsOnColumn(formulaParams.column);
                }
                if (StringUtils.isNotBlank((String)formulaParams.errorColumn)) {
                    updatedDatasetPairLineage.removeRelationsOnColumn(formulaParams.errorColumn);
                }
                for (String formulaInputColumn : formulaInputColumns) {
                    updatedDatasetPairLineage.addFactorizedColumnRelations(formulaInputColumn, formulaParams.column);
                    if (!StringUtils.isNotBlank((String)formulaParams.errorColumn)) continue;
                    updatedDatasetPairLineage.addFactorizedColumnRelations(formulaInputColumn, formulaParams.errorColumn);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    protected static final Logger logger = Logger.getLogger((String)"dku.datasets.sql");

    static class StreamImpl
    extends SingleRowProcessor
    implements Processor {
        private final Parameter parameter;
        private Expression expression;
        private Column cd;
        private Column errorCd;
        private PreviousRowsBuffer previousRowsBuffer;

        StreamImpl(Parameter parameter) {
            this.parameter = parameter;
        }

        public void init() throws Exception {
            this.expression = new Expression(this.parameter.expression, null, null, null, true);
            List<String> inputColumns = this.expression.getVariables();
            Column lastKnown = null;
            for (Column col : this.getColumnFactory().columns()) {
                if (!inputColumns.contains(col.getName())) continue;
                lastKnown = col;
            }
            this.cd = lastKnown == null ? this.getColumnFactory().column(this.parameter.column, Processor.ProcessorRole.OUTPUT_COLUMN) : this.getColumnFactory().columnAfter(lastKnown.getName(), this.parameter.column, Processor.ProcessorRole.OUTPUT_COLUMN);
            this.errorCd = StringUtils.isBlank((String)this.parameter.errorColumn) ? null : this.getColumnFactory().columnAfter(this.cd.getName(), this.parameter.errorColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
            this.expression.setColumnFactory(this.cf);
            if (this.parameter.variablesContext != null) {
                this.expression.setVariablesContext(this.parameter.variablesContext);
            }
            this.previousRowsBuffer = new PreviousRowsBuffer(this.expression);
        }

        public void processRow(Row row) throws Exception {
            Object out = this.expression.evaluate(row, this.previousRowsBuffer.getPreviousRows());
            if (out != null) {
                if (out instanceof ExpressionError) {
                    if (this.errorCd != null) {
                        row.put(this.errorCd, out.toString());
                    }
                } else {
                    String outValue = out instanceof LocalDateTime ? out.toString().replace('T', ' ') : out.toString();
                    row.put(this.cd, outValue);
                }
            }
            if (this.previousRowsBuffer.needBuffering()) {
                this.previousRowsBuffer.addRow(row, this.getColumnFactory());
            }
        }

        public void postProcess() throws Exception {
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter params;

        private SQLTranslator(Parameter params) {
            this.params = params;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            ExpressionBuilder expr;
            boolean columnExisted;
            boolean needsSubquery = false;
            if (DKUApp.getParams().getBoolParam("dku.prepare.sql.formula.alwaysMakeSubquery", false)) {
                needsSubquery = true;
            } else if (StringUtils.isNotBlank((String)this.params.forcedSQLTranslation)) {
                needsSubquery = true;
            } else {
                Expression grel = new Expression(this.params.expression, chain);
                grel.setVariablesContext(this.params.variablesContext);
                try {
                    GrelToQueryTranslator translator = new GrelToQueryTranslator(new GrelToQueryMapping(chain.getDialect()));
                    translator.translateToQuery(grel, true);
                    translator = new GrelToQueryTranslator(new GrelToQueryMapping(chain.getDialect()));
                    List<String> usedColumns = translator.getUsedColumns(grel, true);
                    usedColumns.add(this.params.column);
                    logger.info((Object)("pre-translated successfully, it uses columns: " + JSON.json(usedColumns)));
                    needsSubquery = chain.isAnyCreatedOrModifiedByCurrentQuery(usedColumns);
                }
                catch (Throwable t) {
                    logger.info((Object)"pre-translation failed, will not be SQL translatable at all");
                    needsSubquery = true;
                }
            }
            logger.info((Object)("Translating formula: " + this.params.expression + " makeSubquery=" + needsSubquery));
            if (needsSubquery) {
                chain = chain.makeSubquery();
            }
            boolean bl = columnExisted = chain.getCurrentColumn(this.params.column) != null;
            if (StringUtils.isNotBlank((String)this.params.forcedSQLTranslation)) {
                expr = new ExpressionBuilder.ExpressionBuilderFactory().expr(this.params.forcedSQLTranslation);
            } else {
                Expression grel = new Expression(this.params.expression, chain);
                grel.setVariablesContext(this.params.variablesContext);
                GrelToQueryTranslator translator = new GrelToQueryTranslator(new GrelToQueryMapping(chain.getDialect()));
                GrelTranslator.TranslationResult<ExpressionBuilder> tr = translator.translateToQuery(grel, true);
                logger.info((Object)("Translation result " + JSON.json(tr)));
                assert (tr.isFullyTranslated);
                expr = (ExpressionBuilder)tr.result;
            }
            Expression exprForPosition = new Expression(this.params.expression);
            List<String> inputColumns = exprForPosition.getVariables();
            logger.info((Object)("input columns " + JSON.json(inputColumns)));
            SchemaColumn lastKnown = null;
            Iterator<SchemaColumn> iterator = chain.getCurrentColumns(inputColumns).iterator();
            while (iterator.hasNext()) {
                SchemaColumn col;
                lastKnown = col = iterator.next();
            }
            Type outputType = expr.expr != null ? expr.expr.outputType.dssType : null;
            int columnMaxLength = chain.getDialect().getDefaultVarcharLen();
            if (this.params.forcedCast != null && this.params.forcedCast.getTypeString() != null) {
                outputType = this.params.forcedCast.getType();
                if (-1 != this.params.forcedCast.maxLength) {
                    columnMaxLength = this.params.forcedCast.maxLength;
                }
                expr = expr.cast(outputType, columnMaxLength);
            } else if (outputType == null) {
                outputType = Type.STRING;
            }
            if (lastKnown == null) {
                chain.addColumn(new SchemaColumn(this.params.column, outputType, columnMaxLength));
            } else if (!columnExisted) {
                chain.addColumnAfter(lastKnown.getName(), new SchemaColumn(this.params.column, outputType, columnMaxLength));
            } else {
                chain.replaceColumn(this.params.column, new SchemaColumn(this.params.column, outputType, columnMaxLength));
            }
            if (columnExisted) {
                chain.coalesceSelect(this.params.column, expr, this.params.column);
            } else {
                chain.select(expr, this.params.column);
            }
            return chain;
        }
    }

    public static class Parameter
    implements StepParams,
    StepParamsWithVariablesContext {
        private static final long serialVersionUID = -1L;
        public String column;
        public String errorColumn;
        public String expression;
        SchemaColumn forcedCast;
        String forcedSQLTranslation;
        transient VariablesContext variablesContext;

        public void validate() throws IllegalArgumentException {
        }

        @Override
        public void setVariablesContext(VariablesContext vc) {
            this.variablesContext = vc;
        }
    }
}

