/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.meanings.AbstractBasicMeaningsService;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class MeaningTranslate
extends AppliesToProcessor {
    public static final ProcessorMeta<MeaningTranslate, Parameter> META = new ProcessorMeta<MeaningTranslate, Parameter>(){

        @Override
        public String getName() {
            return "MeaningTranslate";
        }

        @Override
        public String getDocPage() {
            return "meaning-translate";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MISC});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.MeaningTranslate.HELP", "This processor replaces values according to the chosen meaning's mapping definitions. It requires a 'Value mapping' meaning.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.MeaningTranslate.DESCRIPTION", 1.actionVerb("Translate") + " values using meaning"), null, false).withParam("meaningId", "type", true, false, this.translate(language, "SHAKER.PROCESSOR.MeaningTranslate.DESCRIPTION.MEANING_ID", "Meaning to use")).withParam("outCol", "string", false, true, this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN_EMPTY_FOR_INPLACE", "Output column (empty for in-place)"));
        }

        @Override
        public Object selfReport(Parameter parameter) {
            JsonObject obj = AppliesToProcessor.selfReport(parameter);
            obj.remove("outCD");
            obj.remove("meaningId");
            return obj;
        }

        @Override
        public MeaningTranslate build(Parameter parameter) throws Exception {
            throw new UnsupportedOperationException("This processor requires a PipelineContext");
        }

        @Override
        public MeaningTranslate build(Parameter parameter, BaseProcessorsFactory.PipelineContext context) throws Exception {
            if (context == null) {
                return this.build(parameter);
            }
            return new MeaningTranslate(parameter, context.basicMeaningsService);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter meaningTranslateParams = (Parameter)pss.params;
            if (AppliesToProcessor.AppliesTo.SINGLE_COLUMN.equals((Object)meaningTranslateParams.appliesTo) && meaningTranslateParams.columns.isEmpty()) {
                throw new IllegalConfigurationException("Missing input column information for lineage on the meaning translate processor.");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (AppliesToProcessor.AppliesTo.SINGLE_COLUMN.equals((Object)meaningTranslateParams.appliesTo) && StringUtils.isNotBlank((String)meaningTranslateParams.outCol)) {
                    updatedDatasetPairLineage.addFactorizedColumnRelations((String)meaningTranslateParams.columns.get(0), meaningTranslateParams.outCol);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private final AbstractBasicMeaningsService meaningsService;
    private Parameter parameter;
    private Column outCD;
    private Map<String, String> mapping;
    private StringNormalizationMode normalizationMode;

    @Override
    public void init() throws Exception {
        super.init();
        UserDefinedMeaning udm = this.meaningsService.getUDM(this.parameter.meaningId);
        if (udm == null) {
            throw ErrorContext.iaef((String)"Unknown meaning: %s", (Object)this.parameter.meaningId, (Object[])new Object[0]);
        }
        if (udm.type != UserDefinedMeaning.Type.VALUES_MAPPING) {
            throw ErrorContext.iaef((String)"Meaning %s has no value mapping", (Object)this.parameter.meaningId, (Object[])new Object[0]);
        }
        this.mapping = udm.getNormalizedValueMap();
        this.normalizationMode = udm.normalizationMode;
        if (this.parameter.appliesTo == AppliesToProcessor.AppliesTo.SINGLE_COLUMN && StringUtils.isNotBlank((String)this.parameter.outCol)) {
            this.outCD = this.getColumnFactory().columnAfter((String)this.parameter.columns.get(0), this.parameter.outCol, Processor.ProcessorRole.OUTPUT_COLUMN);
        }
    }

    public MeaningTranslate(Parameter parameter, AbstractBasicMeaningsService basicMeaningsService) throws Exception {
        this.parameter = parameter;
        this.meaningsService = basicMeaningsService;
    }

    public void postProcess() {
    }

    @Override
    public AppliesToProcessor.AppliesToParams getParams() {
        return this.parameter;
    }

    @Override
    public void processRowForColumns(Row row, Iterable<Column> columns) throws Exception {
        for (Column cd : columns) {
            String v = row.get(cd);
            if (v != null) {
                v = this.normalizationMode.apply(v);
            }
            String output = this.mapping.get(v);
            if (this.outCD != null) {
                row.put(this.outCD, output);
                continue;
            }
            row.put(cd, output);
        }
    }

    public static class Parameter
    extends AppliesToProcessor.AppliesToParams {
        private static final long serialVersionUID = -1L;
        public String meaningId;
        public String outCol;
    }
}

