/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform.visualif;

import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.shaker.processors.transform.visualif.VisualIfDesc;
import java.util.Set;

public class VisualIfDescUtils {
    public static String convertVisualIfToGrelExpression(VisualIfDesc visualIfDesc, Set<String> columns) throws Exception {
        return VisualIfDescUtils.convertVisualIfToGrelExpression(visualIfDesc.ifThen, VisualIfDescUtils.convertToGrelElseIfsStartingFromIdx(visualIfDesc, columns, 0, 1), columns, 0);
    }

    private static String convertToGrelElseIfsStartingFromIdx(VisualIfDesc visualIfDesc, Set<String> columns, int startIdx, int depth) throws Exception {
        if (startIdx >= visualIfDesc.elseIfThens.size()) {
            if (visualIfDesc.elseActions.isEmpty()) {
                return VisualIfDescUtils.buildElseExpression(visualIfDesc, columns, depth);
            }
            return VisualIfDescUtils.convertActionToGrelExpression(visualIfDesc.elseActions.get(0), columns, depth);
        }
        return VisualIfDescUtils.convertVisualIfToGrelExpression(visualIfDesc.elseIfThens.get(startIdx), VisualIfDescUtils.convertToGrelElseIfsStartingFromIdx(visualIfDesc, columns, startIdx + 1, depth + 1), columns, depth);
    }

    private static String buildElseExpression(VisualIfDesc visualIfDesc, Set<String> columns, int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(Math.max(0, depth)));
        String outputColumnName = visualIfDesc.ifThen.actions.get((int)0).outputColumnName;
        VisualIfDescUtils.appendAssignColumnValueActionInGrelFormat(columns, outputColumnName, sb);
        return sb.toString();
    }

    private static String convertVisualIfToGrelExpression(VisualIfDesc.IfThen ifThen, String elseAction, Set<String> columns, int depth) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(Math.max(0, depth)));
        sb.append("if(");
        sb.append(FilterDescUtils.getGrelExpression(ifThen.filter));
        sb.append(", ");
        sb.append(VisualIfDescUtils.convertActionToGrelExpression(ifThen.actions.get(0), columns, 0));
        if (elseAction != null) {
            sb.append(",\n");
            sb.append(elseAction);
        }
        sb.append("\n");
        sb.append("\t".repeat(Math.max(0, depth)));
        sb.append(")");
        return sb.toString();
    }

    private static String convertActionToGrelExpression(VisualIfDesc.Action action, Set<String> columns, int indentation) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(Math.max(0, indentation)));
        if (action.operator == VisualIfDesc.ActionOperator.ASSIGN_VALUE && action.value != null && !action.value.isEmpty()) {
            sb.append("\"");
            sb.append(action.value);
            sb.append("\"");
        } else if (action.operator == VisualIfDesc.ActionOperator.ASSIGN_FORMULA && action.formula != null && !action.formula.isEmpty()) {
            sb.append(action.formula);
        } else if (action.operator == VisualIfDesc.ActionOperator.ASSIGN_COLUMN && action.column != null && !action.column.isEmpty()) {
            if (!columns.contains(action.column)) {
                throw new IllegalArgumentException("Column " + action.column + " not found in columns. Cannot assign it to " + action.outputColumnName);
            }
            sb.append("val('");
            sb.append(action.column);
            sb.append("')");
        } else {
            throw new IllegalArgumentException("No value, formula or column in action");
        }
        return sb.toString();
    }

    private static void appendAssignColumnValueActionInGrelFormat(Set<String> columns, String outputColumnName, StringBuilder sb) {
        if (columns.contains(outputColumnName)) {
            sb.append("val('");
            sb.append(outputColumnName);
            sb.append("')");
        } else {
            sb.append("null");
        }
    }
}

