/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.pivot.frontend.model.CustomMeasure;
import com.dataiku.dip.pivot.frontend.model.DimensionDef;
import com.dataiku.dip.pivot.frontend.model.HierarchyDef;
import com.dataiku.dip.server.notifications.backend.DatasetChartsChangedEvent;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasetExploreSettingsDAO {
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    protected PubSubService pubSub;

    public DatasetExploreSettings get(String projectKey, String datasetName) throws IOException {
        return this.get(projectKey, datasetName, false);
    }

    public DatasetExploreSettings getUnsafe(String projectKey, String datasetName) throws IOException {
        return this.get(projectKey, datasetName, true);
    }

    public DatasetExploreSettings getCapture(String projectKey, String streamingEndpointId) throws IOException {
        RelFile pristineFile;
        TransactionRef t = TransactionContext.retrieveRead();
        DatasetExploreSettings ret = !t.isFile(pristineFile = this.getFileForStreamingEndpoint(projectKey, streamingEndpointId)) ? new DatasetExploreSettings() : (DatasetExploreSettings)t.readObject(pristineFile, DatasetExploreSettings.class);
        if (ret.script == null) {
            ret.script = this.initScript(projectKey);
        }
        return ret;
    }

    public void save(String projectKey, String datasetSmartName, DatasetExploreSettings exploreSettings) throws IOException {
        ErrorContext.checkNotNull((Object)exploreSettings);
        ErrorContext.checkNotNull((Object)exploreSettings.script);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(this.getFileForDataset(projectKey, datasetSmartName), (Object)exploreSettings);
        AnyLoc datasetLoc = AnyLoc.resolveSmart(projectKey, datasetSmartName);
        if (datasetLoc.getProjectKey().equals(projectKey)) {
            DatasetChartsChangedEvent chartsChangedEvent = new DatasetChartsChangedEvent(datasetLoc, exploreSettings.charts);
            this.pubSub.publish(chartsChangedEvent);
        }
    }

    public void delete(String projectKey, String datasetSmartName) throws IOException {
        RelFile f;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (t.exists(f = this.getFileForDataset(projectKey, datasetSmartName))) {
            t.deleteFile(f);
        }
    }

    public void saveCapture(String projectKey, String streamingEndpointId, DatasetExploreSettings exploreSettings) throws IOException {
        ErrorContext.checkNotNull((Object)exploreSettings);
        ErrorContext.checkNotNull((Object)exploreSettings.script);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(this.getFileForStreamingEndpoint(projectKey, streamingEndpointId), (Object)exploreSettings);
    }

    public void deleteCapture(String projectKey, String streamingEndpointId) throws IOException {
        RelFile f;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (t.exists(f = this.getFileForStreamingEndpoint(projectKey, streamingEndpointId))) {
            t.deleteFile(f);
        }
    }

    private DatasetExploreSettings get(String projectKey, String datasetName, boolean unsafe) throws IOException {
        DatasetExploreSettings ret;
        RelFile pristineFile;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(pristineFile = this.getFileForDataset(projectKey, datasetName))) {
            ret = new DatasetExploreSettings();
        } else {
            DatasetExploreSettings datasetExploreSettings = ret = unsafe ? (DatasetExploreSettings)t.readObjectUnsafe(pristineFile, DatasetExploreSettings.class) : (DatasetExploreSettings)t.readObject(pristineFile, DatasetExploreSettings.class);
        }
        if (ret.script == null) {
            ret.script = this.initScript(projectKey);
        }
        if (ret.interactiveSearch == null) {
            ret.interactiveSearch = new DatasetExploreSettings.DatasetInteractiveSearch();
        }
        if (ret.customMeasures == null) {
            ret.customMeasures = new ArrayList<CustomMeasure>();
        }
        if (ret.reusableDimensions == null) {
            ret.reusableDimensions = new ArrayList<DimensionDef>();
        }
        if (ret.hierarchies == null) {
            ret.hierarchies = new ArrayList<HierarchyDef>();
        }
        return ret;
    }

    private SerializedShakerScript initScript(String projectKey) throws IOException {
        SerializedShakerScript script = new SerializedShakerScript();
        GeneralSettingsDAO.SoftHardLimit projectLimit = this.projectsDAO.getMandatoryUnsafe((String)projectKey).settings.limitsSettings.memSampleBytes;
        GeneralSettingsDAO.SoftHardLimit globalLimit = this.generalSettingsDAO.getUnsafe().limits.memSampleBytes;
        long resultingSoftLimit = -1L;
        if (globalLimit.soft != -1L && projectLimit.soft != -1L) {
            resultingSoftLimit = Math.min(projectLimit.soft, globalLimit.soft);
        } else if (projectLimit.soft != -1L) {
            resultingSoftLimit = projectLimit.soft;
        } else if (globalLimit.soft != -1L) {
            resultingSoftLimit = globalLimit.soft;
        }
        assert (script.explorationSampling != null);
        assert (script.explorationSampling.selection != null);
        script.explorationSampling.selection.maxStoredBytes = resultingSoftLimit;
        return script;
    }

    private RelFile getFileForDataset(String projectKey, String datasetName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)datasetName), (Object)"Dataset name is not specified");
        return new RelFile(new String[]{"projects", projectKey, "explore", datasetName + ".json"});
    }

    private RelFile getFileForStreamingEndpoint(String projectKey, String streamingEndpointId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)streamingEndpointId), (Object)"Dataset name is not specified");
        return new RelFile(new String[]{"projects", projectKey, "explore-streaming-endpoints", streamingEndpointId + ".json"});
    }
}

