/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.GuavaCacheMetrics;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

public class ScriptTableCache {
    private final Cache<String, CacheEntry> cache;
    private final boolean perUserCaches;
    private final Gson gsonWithOrderedMaps = ScriptTableCache.createGsonWithOrderedMaps();
    private static final Logger logger = Logger.getLogger((String)"dku.shaker.cache");

    public ScriptTableCache() {
        Params p = ApplicationConfigurator.getParams();
        this.perUserCaches = p.getBoolParam("dku.security.perUserCaches.tableMemoryCache.enabled", false);
        RemovalListener<String, CacheEntry> debugEvictionListener = new RemovalListener<String, CacheEntry>(){

            public void onRemoval(RemovalNotification<String, CacheEntry> n) {
                if (n.wasEvicted()) {
                    String cause = n.getCause().name();
                    logger.debug((Object)("Shaker MemoryCache: eviction for " + ((CacheEntry)n.getValue()).inputDataset + ", evicted due to " + String.valueOf(n.getCause()) + " key=" + (String)n.getKey()));
                }
            }
        };
        this.cache = CacheBuilder.newBuilder().recordStats().weigher((Weigher)new CacheWeigher()).maximumWeight(p.getLongParam("dku.caches.shaker.memtable.maxWeightKB", 200000L)).concurrencyLevel(1).expireAfterAccess(p.getLongParam("dku.caches.shaker.memtable.expireAfterAccessS", 900L), TimeUnit.SECONDS).removalListener((RemovalListener)debugEvictionListener).build();
        DSSMetrics.registry().registerAll(GuavaCacheMetrics.cacheMetricsSet((String)"shaker.memtable", this.cache));
        DSSMetrics.registry().register("dku.caches.shaker.memtable.cachedRows", (Metric)new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (Map.Entry entry : ScriptTableCache.this.cache.asMap().entrySet()) {
                    CacheEntry ce = (CacheEntry)entry.getValue();
                    if (ce == null || ce.table == null || ce.table.table == null) continue;
                    total += (long)ce.table.table.rows.size();
                }
                return total;
            }
        });
        DSSMetrics.registry().register("dku.caches.shaker.memtable.cachedMem", (Metric)new CachedGauge<Long>(5L, TimeUnit.MINUTES){

            public Long loadValue() {
                long total = 0L;
                for (Map.Entry entry : ScriptTableCache.this.cache.asMap().entrySet()) {
                    CacheEntry ce = (CacheEntry)entry.getValue();
                    if (ce == null || ce.table == null || ce.table.table == null) continue;
                    total += ce.table.table.approximateMemUsage();
                }
                return total;
            }
        });
    }

    public void removeForDatasetForUser(AuthCtx user, String projectKey, String datasetName) {
        this.removeForDataset(user, projectKey, datasetName);
    }

    public void removeForDatasetForAllUsers(String projectKey, String datasetName) {
        this.removeForDataset(null, projectKey, datasetName);
    }

    private synchronized void removeForDataset(@Nullable AuthCtx authCtx, String projectKey, String datasetName) {
        ArrayList<String> toClear = new ArrayList<String>();
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            CacheEntry ce = (CacheEntry)entry.getValue();
            if (ce == null || !Objects.equals(ce.inputDataset, projectKey + "." + datasetName) || authCtx != null && !Objects.equals(ce.authCtxIdentifier, authCtx.getIdentifier())) continue;
            logger.debug((Object)("Shaker MemoryCache: removing previous cache entry for dataset " + projectKey + "." + datasetName + (String)(authCtx == null ? "" : " for user " + authCtx.getIdentifier())));
            toClear.add((String)entry.getKey());
        }
        this.cache.invalidateAll(toClear);
    }

    public void removeForStreamingEndpointForUser(AuthCtx user, String projectKey, String streamingEndpointId) {
        this.removeForStreamingEndpoint(user, projectKey, streamingEndpointId);
    }

    public void removeForStreamingEndpointForAllUsers(String projectKey, String streamingEndpointId) {
        this.removeForStreamingEndpoint(null, projectKey, streamingEndpointId);
    }

    public synchronized void removeForStreamingEndpoint(@Nullable AuthCtx authCtx, String projectKey, String streamingEndpointId) {
        ArrayList<String> toClear = new ArrayList<String>();
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            CacheEntry ce = (CacheEntry)entry.getValue();
            if (ce == null || !Objects.equals(ce.inputStreamingEndpoint, projectKey + "." + streamingEndpointId) || authCtx != null && !Objects.equals(ce.authCtxIdentifier, authCtx.getIdentifier())) continue;
            logger.debug((Object)("Shaker MemoryCache: removing previous cache entry for streaming endpoint " + projectKey + "." + streamingEndpointId + (String)(authCtx == null ? "" : " for user " + authCtx.getIdentifier())));
            toClear.add((String)entry.getKey());
        }
        this.cache.invalidateAll(toClear);
    }

    public synchronized void removeForProjectForAllUsers(String projectKey) {
        ArrayList<String> toClear = new ArrayList<String>();
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            CacheEntry ce = (CacheEntry)entry.getValue();
            if (ce == null || !Objects.equals(ce.projectKey, projectKey)) continue;
            logger.debug((Object)("Shaker MemoryCache: removing previous cache entry for " + projectKey));
            toClear.add((String)entry.getKey());
        }
        this.cache.invalidateAll(toClear);
    }

    public synchronized void removeAll() {
        this.cache.invalidateAll();
    }

    public synchronized void put(AuthCtx authCtx, Dataset dataset, SerializedShakerScript script, String requestedSampleId, MemScriptRunner.TableWithReport table) {
        String cacheKey = this.cacheKey(authCtx, dataset, script, requestedSampleId);
        DSSMetrics.registry().meter("dku.caches.shaker.memtable.put").mark();
        if (table != null && table.table != null && table.table.rows != null) {
            DSSMetrics.registry().histogram("dku.caches.shaker.memtable.putRows").update(table.table.rows.size());
            DSSMetrics.registry().histogram("dku.caches.shaker.memtable.putMem").update(table.table.approximateMemUsage());
        }
        this.removeForDatasetForUser(authCtx, dataset.getProjectKey(), dataset.getName());
        CacheEntry entry = new CacheEntry();
        entry.authCtxIdentifier = authCtx.getIdentifier();
        entry.projectKey = dataset.getProjectKey();
        entry.inputDataset = dataset.getFullName();
        entry.scriptData = JSON.pretty((Object)script);
        entry.table = table;
        logger.debug((Object)("Shaker MemoryCache put on dataset " + dataset.getFullName() + " key=" + cacheKey + " weight=" + new CacheWeigher().weigh(cacheKey, entry)));
        this.cache.put((Object)cacheKey, (Object)entry);
    }

    public synchronized void put(AuthCtx authCtx, StreamingEndpoint streamingEndpoint, SerializedShakerScript script, String requestedSampleId, MemScriptRunner.TableWithReport table) {
        String cacheKey = this.cacheKey(authCtx, streamingEndpoint, script, requestedSampleId);
        DSSMetrics.registry().meter("dku.caches.shaker.memtable.put").mark();
        if (table != null && table.table != null && table.table.rows != null) {
            DSSMetrics.registry().histogram("dku.caches.shaker.memtable.putRows").update(table.table.rows.size());
            DSSMetrics.registry().histogram("dku.caches.shaker.memtable.putMem").update(table.table.approximateMemUsage());
        }
        this.removeForStreamingEndpointForUser(authCtx, streamingEndpoint.getProjectKey(), streamingEndpoint.getId());
        CacheEntry entry = new CacheEntry();
        entry.authCtxIdentifier = authCtx.getIdentifier();
        entry.projectKey = streamingEndpoint.getProjectKey();
        entry.inputStreamingEndpoint = streamingEndpoint.getFullId();
        entry.scriptData = JSON.pretty((Object)script);
        entry.table = table;
        this.cache.put((Object)cacheKey, (Object)entry);
        logger.debug((Object)("Shaker MemoryCache put on streaming endpoint " + streamingEndpoint.getFullId() + " key=" + cacheKey));
    }

    public synchronized MemScriptRunner.TableWithReport get(AuthCtx authCtx, Dataset dataset, SerializedShakerScript dataView, String requestedSampleId) {
        String cacheKey = this.cacheKey(authCtx, dataset, dataView, requestedSampleId);
        CacheEntry ce = (CacheEntry)this.cache.getIfPresent((Object)cacheKey);
        DSSMetrics.registry().meter("dku.caches.shaker.memtable.get").mark();
        logger.debug((Object)("Shaker MemoryCache get on dataset " + dataset.getFullName() + " key=" + cacheKey + ": " + (ce == null ? "miss" : "hit")));
        if (ce != null) {
            DSSMetrics.registry().meter("dku.caches.shaker.memtable.cacheHit").mark();
            return ce.table;
        }
        DSSMetrics.registry().meter("dku.caches.shaker.memtable.cacheMissFull").mark();
        return null;
    }

    public synchronized MemScriptRunner.TableWithReport get(AuthCtx authCtx, StreamingEndpoint streamingEndpoint, SerializedShakerScript dataView, String requestedSampleId) {
        String cacheKey = this.cacheKey(authCtx, streamingEndpoint, dataView, requestedSampleId);
        CacheEntry ce = (CacheEntry)this.cache.getIfPresent((Object)cacheKey);
        DSSMetrics.registry().meter("dku.caches.shaker.memtable.get").mark();
        logger.debug((Object)("Shaker MemoryCache get on streaming endpoint " + streamingEndpoint.getFullId() + " key=" + cacheKey + ": " + (ce == null ? "miss" : "hit")));
        if (ce != null) {
            DSSMetrics.registry().meter("dku.caches.shaker.memtable.cacheHit").mark();
            return ce.table;
        }
        DSSMetrics.registry().meter("dku.caches.shaker.memtable.cacheMissFull").mark();
        return null;
    }

    private String cacheKey(AuthCtx authCtx, Dataset dataset, SerializedShakerScript script, String requestedSampleId) {
        SerializedDataset sd = dataset.serialize();
        sd.setAllFieldsToNonRawMode();
        String base = "ds=" + DigestUtils.md5Hex((String)JSON.json((Object)sd)) + "--scr=" + DigestUtils.md5Hex((String)this.jsonWithOrderedMaps(script)) + "--samp=" + requestedSampleId;
        if (this.perUserCaches) {
            return "u=" + authCtx.getIdentifier() + "--" + base;
        }
        return base;
    }

    private String cacheKey(AuthCtx authCtx, StreamingEndpoint streamingEndpoint, SerializedShakerScript script, String requestedSampleId) {
        StreamingEndpoint se = (StreamingEndpoint)JSON.deepCopy((Object)streamingEndpoint);
        String base = "ds=" + DigestUtils.md5Hex((String)JSON.json((Object)se)) + "--scr=" + DigestUtils.md5Hex((String)this.jsonWithOrderedMaps(script)) + "--samp=" + requestedSampleId;
        if (this.perUserCaches) {
            return "u=" + authCtx.getIdentifier() + "--" + base;
        }
        return base;
    }

    private String jsonWithOrderedMaps(Object o) {
        if (o == null) {
            return null;
        }
        return this.gsonWithOrderedMaps.toJson(o);
    }

    private static Gson createGsonWithOrderedMaps() {
        return JSON.createGsonBuilder().registerTypeAdapter(Map.class, (Object)new MapSerializer()).create();
    }

    private static class CacheWeigher
    implements Weigher<String, CacheEntry> {
        private CacheWeigher() {
        }

        public int weigh(String key, CacheEntry ce) {
            if (ce != null && ce.table != null && ce.table.table != null) {
                return (int)(ce.table.table.approximateMemUsage() / 1000L);
            }
            return 0;
        }
    }

    private static class CacheEntry {
        String inputStreamingEndpoint;
        String inputDataset;
        String projectKey;
        String authCtxIdentifier;
        String scriptData;
        MemScriptRunner.TableWithReport table;

        private CacheEntry() {
        }
    }

    private static class MapSerializer
    implements JsonSerializer<Map> {
        private MapSerializer() {
        }

        public JsonElement serialize(Map src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            TreeSet<Object> keys = new TreeSet<Object>(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 == null) {
                        return o2 == null ? 0 : -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return o1.toString().compareTo(o2.toString());
                }
            });
            keys.addAll(src.keySet());
            for (Object e : keys) {
                if (e == null) continue;
                result.add(e.toString(), context.serialize(src.get(e)));
            }
            return result;
        }
    }
}

