/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.yarnaware;

import com.dataiku.dip.spark.yarnaware.YarnClusterCache;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class YarnClusterCacheDAO {
    public YarnClusterCache get() throws IOException {
        RelFile f;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (tr.exists(f = this.cacheFile())) {
            return (YarnClusterCache)tr.readObject(f, YarnClusterCache.class);
        }
        return new YarnClusterCache();
    }

    public YarnClusterCache getUnsafe() throws IOException {
        RelFile f;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (tr.exists(f = this.cacheFile())) {
            return (YarnClusterCache)tr.readObjectUnsafe(f, YarnClusterCache.class);
        }
        return new YarnClusterCache();
    }

    public void save(YarnClusterCache cache) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        tr.writeObject(this.cacheFile(), (Object)cache);
    }

    private RelFile cacheFile() {
        return new RelFile(new String[]{"yarn-cluster-cache.json"});
    }
}

