/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.RowSizeLimiter;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class NetezzaSQLDialect
extends GenericSQLDialect {
    DateTimeFormatter timestampFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS").withZone(DateTimeZone.UTC);

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, 5, "smallint", new Integer[0]);
            }
            case STRING: {
                return new DSSTypeSQLMapping(Type.STRING, -9, "nvarchar(" + schemaColumn.getMaxLength() + ")", new Integer[]{2003, 1111, 1, -15, 12, -1, -16, 91, 93, 92});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public void fill(PreparedStatement ps2, Type dssType, int colIdx, String dssStrVal) throws SQLException {
        switch (dssType) {
            case DATE: {
                long timestamp = this.typeDate.msSinceEpoch(dssStrVal);
                if (timestamp == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid date: " + dssStrVal);
                }
                String formatted = this.timestampFormatter.print(timestamp);
                ps2.setString(colIdx, formatted);
                break;
            }
            default: {
                super.fill(ps2, dssType, colIdx, dssStrVal);
            }
        }
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM (" + inputDateExpression + "))";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM (" + inputDateExpression + "))";
            }
            case MINUTE_OF_HOUR: {
                return "EXTRACT(MINUTE FROM (" + inputDateExpression + "))";
            }
            case SECOND_OF_MINUTE: {
                return "EXTRACT(SECOND FROM (" + inputDateExpression + "))";
            }
            case MILLISECOND_OF_SECOND: {
                return "MOD(EXTRACT(MILLISECOND FROM (" + inputDateExpression + ")), 1000)";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM (" + inputDateExpression + "))";
            }
            case WEEK_OF_YEAR: {
                return "EXTRACT(WEEK FROM (" + inputDateExpression + "))";
            }
            case QUARTER_OF_YEAR: {
                return "EXTRACT(QUARTER FROM (" + inputDateExpression + "))";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM (" + inputDateExpression + "))";
            }
            case DAY_OF_WEEK: {
                return "EXTRACT(ISODOW FROM (" + inputDateExpression + "))";
            }
            case SECOND_FROM_EPOCH: {
                return "EXTRACT(EPOCH FROM (" + inputDateExpression + "))";
            }
            case MILLIS_FROM_EPOCH: {
                return "(EXTRACT(EPOCH FROM (" + inputDateExpression + ")) * 1000)";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Netezza", part));
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        String dateAtGmt = inputDateExpression;
        switch (rounding) {
            case DAY: {
                return "date_trunc('DAY'," + dateAtGmt + ")";
            }
            case HOUR: {
                return "date_trunc('HOUR'," + dateAtGmt + ")";
            }
            case WEEK: {
                return "date_trunc('WEEK'," + dateAtGmt + ")";
            }
            case MONTH: {
                return "date_trunc('MONTH'," + dateAtGmt + ")";
            }
            case YEAR: {
                return "date_trunc('YEAR'," + dateAtGmt + ")";
            }
            case QUARTER: {
                return "date_trunc('QUARTER'," + dateAtGmt + ")";
            }
            case MINUTE: {
                return "date_trunc('MINUTE'," + dateAtGmt + ")";
            }
            case SECOND: {
                return "date_trunc('SECOND'," + dateAtGmt + ")";
            }
        }
        throw new NotImplementedException("Date trunc with unit '" + rounding.toString() + "' not implemented for Netezza");
    }

    @Override
    public boolean supportsIndexing() {
        return false;
    }

    @Override
    public String captureGroup(int group) {
        return "\\" + group;
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 127;
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.MultiLineCommentFinder.META, QuotedPortionFinders.SingleQuotedNoEscapeFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META, QuotedPortionFinders.OracleQuotedStringLiteralFinder.META};
    }

    @Override
    public void setDefaultLengthForSchemaColumn(Schema schema, List<SchemaColumn> keyColumns, InfoMessage.InfoMessages messages) throws IllegalArgumentException {
        RowSizeLimiter limiter = new RowSizeLimiter("Netezza", DatasetCodes.WARN_DATASET_NETEZZA_SCHEMA_TOO_LARGE, 65000, 4, false);
        limiter.setDefaultLengthForSchemaColumn(schema, keyColumns, messages);
    }

    @Override
    public void initOperators() {
        super.initOperators();
        this.addGenericFunction(QueryUtils.OperatorType.STDDEV_SAMP, "STDDEV_SAMP", QueryUtils.Arity.UNARY);
        this.addGenericOperator(QueryUtils.OperatorType.CONCAT, "||", QueryUtils.Arity.NARY, GenericSQLDialect.SQLPriority.CONCAT.priority, true);
    }

    @Override
    protected String makeSimpleReplace(QueryUtils.AbstractOperator op, QueryAst.Expr[] args) {
        return String.format("sql_functions..REPLACE(%1$s, %2$s, %3$s)", op.toSQLNoBrackets(args[0]), op.toSQLNoBrackets(args[1]), op.toSQLNoBrackets(args[2]));
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 16000;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public String getId() {
        return "Netezza";
    }
}

