/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TablePartitioning {
    public PartitionType partitionType;
    public String field;
    public Range range;
    public boolean requirePartitionFilter;
    public List<String> clusteringFields;

    public static TablePartitioning byDate(String field) {
        TablePartitioning result = new TablePartitioning();
        result.partitionType = PartitionType.DATE;
        result.field = field;
        return result;
    }

    public static TablePartitioning byRange(String field, long start, long end, long interval) {
        if (end <= start) {
            throw new IllegalArgumentException("Range end (" + end + ") must be larger than start (" + start + ")");
        }
        if (interval <= 0L) {
            throw new IllegalArgumentException("Range interval must equal to or greater than 1: " + interval);
        }
        TablePartitioning result = new TablePartitioning();
        result.partitionType = PartitionType.RANGE;
        result.field = field;
        result.range = new Range();
        result.range.start = start;
        result.range.end = end;
        result.range.interval = interval;
        return result;
    }

    public TablePartitioning withClustering(String ... fields) {
        this.clusteringFields = Arrays.asList(fields);
        return this;
    }

    public TablePartitioning withClustering(List<String> fields) {
        this.clusteringFields = new ArrayList<String>(fields);
        return this;
    }

    public static enum PartitionType {
        DATE,
        RANGE;

    }

    public static class Range {
        public long start;
        public long end;
        public long interval;
    }
}

