/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayDeque;

public class QueryWritingGuardian
implements AutoCloseable {
    public static final String DKU_SQL_GENERATION_MAX_QUERY_LENGTH = "dku.sql.generation.maxQueryLength";
    private static final ThreadLocal<CurrentStatus> currentStatusTL = new ThreadLocal();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.guardian");

    public QueryWritingGuardian() {
        int maxQueryLength = DKUApp.getParams().getIntParam(DKU_SQL_GENERATION_MAX_QUERY_LENGTH, Integer.valueOf(10000000));
        if (currentStatusTL.get() != null) {
            currentStatusTL.get().push();
        } else {
            currentStatusTL.set(new CurrentStatus(maxQueryLength));
        }
    }

    public static int getMark() {
        if (currentStatusTL.get() != null) {
            return currentStatusTL.get().getMark();
        }
        return 0;
    }

    public static void updateAboveMark(int aboveMark) {
        if (currentStatusTL.get() != null) {
            currentStatusTL.get().updateAndCheck(aboveMark);
        }
    }

    @Override
    public void close() {
        boolean empty;
        if (currentStatusTL.get() != null && (empty = currentStatusTL.get().pop())) {
            currentStatusTL.remove();
        }
    }

    private static class CurrentStatus {
        int mark;
        int aboveMark;
        private final int maxQueryLength;
        private ArrayDeque<CurrentStatus> stack;

        CurrentStatus(int maxQueryLength) {
            this.maxQueryLength = maxQueryLength;
        }

        private CurrentStatus(CurrentStatus status) {
            this.mark = status.mark;
            this.aboveMark = status.aboveMark;
            this.maxQueryLength = status.maxQueryLength;
        }

        void push() {
            if (this.stack == null) {
                this.stack = new ArrayDeque();
            }
            CurrentStatus current = new CurrentStatus(this);
            this.stack.push(current);
            this.mark = current.mark + current.aboveMark;
            this.aboveMark = 0;
        }

        boolean pop() {
            if (this.stack == null || this.stack.isEmpty()) {
                return true;
            }
            CurrentStatus last = this.stack.pop();
            this.mark = last.mark;
            this.aboveMark = last.aboveMark;
            return false;
        }

        void updateAndCheck(int aboveMark) {
            this.aboveMark = aboveMark;
            if (this.mark + aboveMark > this.maxQueryLength) {
                logger.errorV("Aborting query SQL writing, query is too longs, reached %d bytes", new Object[]{this.mark + aboveMark});
                throw new IllegalArgumentException("query too long, bailing out");
            }
        }

        int getMark() {
            return this.mark + this.aboveMark;
        }
    }
}

