/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.kafka;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;

public class CompositeSerializer
implements Serializer<Object> {
    private Map<String, Serializer<Object>> serializerByTopic = Maps.newHashMap();
    private Serializer<Object> defaultSerializer;

    public void close() {
        this.defaultSerializer.close();
        for (Serializer<Object> s : this.serializerByTopic.values()) {
            s.close();
        }
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        String defaultSerializerKey = "dku." + (isKey ? "key" : "value") + ".serializer";
        try {
            this.defaultSerializer = this.instantiate(defaultSerializerKey, configs, isKey);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to setup composite serializer", e);
        }
        Pattern keyByTopic = Pattern.compile("^dku\\.(.*)\\." + (isKey ? "key" : "value") + "\\.serializer$");
        for (String key : configs.keySet()) {
            Matcher matcher = keyByTopic.matcher(key);
            if (!matcher.matches()) continue;
            String topic = matcher.group(1);
            try {
                this.serializerByTopic.put(topic, this.instantiate(key, configs, isKey));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to setup composite serializer for topic " + topic, e);
            }
        }
    }

    private Serializer<Object> instantiate(String key, Map<String, ?> configs, boolean isKey) throws ClassNotFoundException {
        HashMap configsCopy = Maps.newHashMap();
        for (Map.Entry<String, ?> e : configs.entrySet()) {
            configsCopy.put(e.getKey(), e.getValue());
        }
        configsCopy.put((isKey ? "key" : "value") + ".serializer", configs.getOrDefault(key, null));
        Serializer s = (Serializer)Utils.newInstance((String)((String)configs.get(key)), Serializer.class);
        s.configure((Map)configsCopy, isKey);
        return s;
    }

    public byte[] serialize(String topic, Object data) {
        return this.serializerByTopic.getOrDefault(topic, this.defaultSerializer).serialize(topic, data);
    }
}

