/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git;

import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.CommitQueue;
import com.dataiku.dip.transactions.git.CommitQueuesManager;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.IGitManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DSSCommitQueuesBehavior
implements CommitQueuesManager.ICommitQueuesBehavior {
    private IGitManager manager;
    private CommitQueue globalQueue;
    private Map<String, CommitQueue> perProjectQueues = new HashMap<String, CommitQueue>();

    public DSSCommitQueuesBehavior(IGitManager manager) {
        this.manager = manager;
        this.globalQueue = new CommitQueue(manager);
    }

    public IGitManager getGitManager() {
        return this.manager;
    }

    private synchronized CommitQueue buildProjectQueue(String projectKey) {
        CommitQueue queue = this.perProjectQueues.get(projectKey);
        if (queue == null) {
            queue = new CommitQueue(this.manager);
            this.perProjectQueues.put(projectKey, queue);
        }
        return queue;
    }

    public synchronized CommitQueue getQueue(CommitDef def) {
        DSSCommitDef commitDef = (DSSCommitDef)def;
        if (commitDef.itemId == null) {
            return this.globalQueue;
        }
        return this.buildProjectQueue(commitDef.itemId);
    }

    public synchronized boolean hasExpired() {
        if (this.globalQueue.hasExpired()) {
            return true;
        }
        for (CommitQueue queue : this.perProjectQueues.values()) {
            if (!queue.hasExpired()) continue;
            return true;
        }
        return false;
    }

    public synchronized void commitExpired() throws IOException {
        this.globalQueue.commitExpired();
        for (CommitQueue queue : this.perProjectQueues.values()) {
            queue.commitExpired();
        }
    }

    public void flushPendingCommits(String projectKey) throws IOException {
        CommitQueue commitQueue = this.perProjectQueues.get(projectKey);
        if (commitQueue != null) {
            commitQueue.commitAll();
        }
    }

    public void close() throws IOException {
        if (this.manager != null) {
            this.manager.close();
            this.manager = null;
        }
    }
}

