/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.StringTransmogrifier;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class HumanReadableIdGenerator {
    private static final int NB_GENERATION_ATTEMPTS = 100;
    private static final List<String> adjectives = Arrays.asList("awesome", "awful", "bad", "bashful", "berserk", "big", "bizarre", "black", "blue", "boring", "brawny", "breezy", "bright", "bubbly", "bumpy", "burgundy", "burly", "cagey", "cheerful", "chilly", "chubby", "classy", "clumsy", "cold", "coral", "crazy", "creepy", "cuddly", "daring", "dashing", "dirty", "ditsy", "dizzy", "drunk", "dry", "dull", "dusty", "eager", "ecstatic", "emerald", "evasive", "evil", "fancy", "fast", "fat", "faulty", "fearless", "filthy", "foamy", "friendly", "frosty", "funky", "funny", "gentle", "giant", "glossy", "good", "goofy", "great", "greedy", "green", "groovy", "grumpy", "guilty", "hairy", "handsome", "happy", "healthy", "heavy", "helpful", "high", "huge", "hungry", "icky", "itchy", "jazzy", "jealous", "jolly", "jumpy", "kind", "large", "lazy", "lean", "little", "lively", "lucky", "macho", "magenta", "magic", "massive", "meek", "mighty", "mindless", "nasty", "needy", "new", "nice", "noisy", "odd", "old", "orange", "peaceful", "prancing", "pretty", "prickly", "proud", "puffy", "purple", "quick", "quiet", "rabid", "rebel", "red", "righteous", "round", "rusty", "sad", "sassy", "scarlet", "scary", "sedate", "shallow", "short", "silly", "skillful", "skinny", "sloppy", "slow", "small", "smelly", "sneaky", "snobby", "stern", "strange", "tacky", "tall", "tan", "teal", "tough", "tricky", "ugly", "uncanny", "wicked", "wild", "wise", "yellow", "young", "zany", "zen", "zesty");
    private static final List<String> nouns = Arrays.asList("angel", "ant-lion", "ant", "avocado", "badger", "banshee", "basilisk", "bat", "bear", "bee", "bird", "boat", "bookworm", "buffalo", "butterfly", "cat", "centaur", "chicken", "clam", "cockle", "cookie", "cow", "crab", "crow", "cupcake", "deer", "demon", "devil", "dingo", "dog", "dolphin", "donkey", "dove", "dragonfly", "dragon", "duck", "dwarf", "eagle", "elephant", "elf", "ewe", "fairy", "falcon", "faun", "ferret", "fish", "fly", "fox", "frog", "gecko", "geese", "gerbil", "ghost", "ghoul", "giant", "gnome", "goat", "goblin", "golem", "goomba", "griffin", "hare", "hawk", "hedgehog", "hen", "heron", "horse", "husky", "hyena", "iguana", "kangaroo", "kingfisher", "jelly", "jellyfish", "lion", "lizard", "lobster", "mammoth", "mermaid", "mice", "mole", "monkey", "monster", "moth", "muscle", "newt", "ogre", "orc", "orca", "otter", "owl", "oxen", "oyster", "panther", "parrot", "penguin", "people", "pheasant", "pigeon", "pig", "pike", "plane", "pony", "popcorn", "popsicle", "princess", "rabbit", "rat", "rhino", "robin", "rocket", "rook", "rooster", "salmon", "sandworm", "scorpion", "shark", "sheep", "siren", "skeleton", "snake", "sparrow", "spider", "spirit", "sprite", "squirrel", "starfish", "starling", "stoat", "swan", "tiger", "toad", "toast", "train", "trout", "turkey", "unicorn", "vampire", "wasp", "weasel", "werewolf", "whale", "witch", "wolf", "wombat", "worm", "yak", "yeti", "zebra", "zombie");
    private static final List<String> adverbs = Arrays.asList("always", "angrily", "badly", "boldly", "bravely", "briefly", "brightly", "busily", "clearly", "cruelly", "fast", "fiercely", "gently", "greedily", "happily", "hastily", "honestly", "joyously", "kindly", "lazily", "loosely", "loudly", "madly", "merrily", "neatly", "poorly", "promptly", "quickly", "quietly", "roughly", "rudely", "sadly", "safely", "sharply", "shyly", "slowly", "smoothly", "softly", "sternly", "swiftly", "tightly", "too", "warmly", "weakly", "wildly");
    private static Random random = new Random();

    private static String pick(List<String> stringArray) {
        return stringArray.get(random.nextInt(stringArray.size()));
    }

    public static String generateId() {
        return String.format("%s-%s-%s", HumanReadableIdGenerator.pick(adverbs), HumanReadableIdGenerator.pick(adjectives), HumanReadableIdGenerator.pick(nouns));
    }

    public static String generateIdNoDuplicate(List<String> ids) {
        String candidateId = HumanReadableIdGenerator.generateId();
        for (int i = 0; i < 100; ++i) {
            if (!ids.contains(candidateId)) {
                return candidateId;
            }
            candidateId = HumanReadableIdGenerator.generateId();
        }
        StringTransmogrifier transmogrifier = new StringTransmogrifier("-", 2);
        for (String id : ids) {
            transmogrifier.addAlreadyTransmogrified(id);
        }
        return transmogrifier.transmogrify(candidateId);
    }
}

