/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.wikis;

import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.ProjectBundleActivationFinishedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.ArticlesDAO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArticlesCacheService
implements DSSEventListener<ProjectBundleActivationFinishedEvent> {
    @Autowired
    private ArticlesDAO articlesDAO;
    @Autowired
    private PubSubService pubSub;
    private Map<String, ArticleCache> projectToCache = new HashMap<String, ArticleCache>();

    private synchronized ArticleCache getCache(String projectKey) throws IOException {
        ArticleCache cache = this.projectToCache.get(projectKey);
        if (cache == null) {
            cache = new ArticleCache();
            cache.mapping = new ConcurrentHashMap<String, String>();
            int lastId = 0;
            List articles = this.articlesDAO.listUnsafe(projectKey);
            for (Article article : articles) {
                if (article == null) continue;
                cache.mapping.put(article.id, StringUtils.defaultIfEmpty((String)article.name, (String)"No article name"));
                lastId = Math.max(lastId, NumberUtils.toInt((String)article.id));
            }
            cache.lastId = new AtomicInteger(lastId);
            this.projectToCache.put(projectKey, cache);
        }
        return cache;
    }

    public synchronized void invalidateCacheForProject(String projectKey) {
        this.projectToCache.remove(projectKey);
    }

    public ConcurrentMap<String, String> getNamesMapping(String projectKey) throws IOException {
        return this.getCache((String)projectKey).mapping;
    }

    public String getNameMapping(String projectKey, String articleId) throws IOException {
        return (String)this.getCache((String)projectKey).mapping.get(articleId);
    }

    public void putNameMapping(String projectKey, String articleId, String articleName) throws IOException {
        this.getCache((String)projectKey).mapping.put(articleId, articleName);
    }

    public void removeNameMapping(String projectKey, String articleId) throws IOException {
        this.getCache((String)projectKey).mapping.remove(articleId);
    }

    public String getIdFromName(String projectKey, String articleName) throws IOException {
        for (Map.Entry mappingEntry : this.getCache((String)projectKey).mapping.entrySet()) {
            if (!articleName.equals(mappingEntry.getValue())) continue;
            return (String)mappingEntry.getKey();
        }
        return null;
    }

    public boolean isNameUnique(String projectKey, String articleId, String articleName) throws IOException {
        for (Map.Entry mappingEntry : this.getCache((String)projectKey).mapping.entrySet()) {
            if (((String)mappingEntry.getKey()).equals(articleId) || !articleName.equals(mappingEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    public String computeNextId(String projectKey) throws IOException {
        return String.valueOf(this.getCache((String)projectKey).lastId.incrementAndGet());
    }

    @PostConstruct
    public void installListener() {
        this.pubSub.subscribe("project-bundle-activation-finished", this);
    }

    public void on(ProjectBundleActivationFinishedEvent evt) throws Exception {
        this.invalidateCacheForProject(evt.getProjectKey());
    }

    public class ArticleCache {
        ConcurrentMap<String, String> mapping;
        AtomicInteger lastId;
    }
}

