/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.HasFieldsList;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import java.util.List;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONException;

public class Slice
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length > 1 && args.length <= 3) {
            Object to;
            Object v = args[0];
            Object from = args[1];
            Object object = to = args.length == 3 ? args[2] : null;
            if (v != null && from instanceof Number && (to == null || to instanceof Number)) {
                if (v.getClass().isArray() || v instanceof List || v instanceof HasFieldsList || v instanceof JSONArray) {
                    int end;
                    int length = 0;
                    length = v.getClass().isArray() ? ((Object[])v).length : (v instanceof HasFieldsList ? ((HasFieldsList)v).length() : (v instanceof JSONArray ? ((JSONArray)v).length() : ExpressionUtils.toObjectList(v).size()));
                    int start = ((Number)from).intValue();
                    int n = end = to != null ? ((Number)to).intValue() : length;
                    if (start < 0) {
                        start = length + start;
                    }
                    start = Math.min(length, Math.max(0, start));
                    if (end < 0) {
                        end = length + end;
                    }
                    end = Math.min(length, Math.max(start, end));
                    if (v.getClass().isArray()) {
                        Object[] a2 = new Object[end - start];
                        System.arraycopy(v, start, a2, 0, end - start);
                        return a2;
                    }
                    if (v instanceof HasFieldsList) {
                        return ((HasFieldsList)v).getSubList(start, end);
                    }
                    if (v instanceof JSONArray) {
                        JSONArray a = (JSONArray)v;
                        Object[] a2 = new Object[end - start];
                        for (int i = 0; i < a2.length; ++i) {
                            try {
                                a2[i] = a.get(start + i);
                                continue;
                            }
                            catch (JSONException jSONException) {
                                // empty catch block
                            }
                        }
                        return a2;
                    }
                    return ExpressionUtils.toObjectList(v).subList(start, end);
                }
                String s = v instanceof String ? (String)v : v.toString();
                int start = ((Number)from).intValue();
                if (start < 0) {
                    start = s.length() + start;
                }
                start = Math.min(s.length(), Math.max(0, start));
                if (to != null) {
                    int end = ((Number)to).intValue();
                    if (end < 0) {
                        end = s.length() + end;
                    }
                    end = Math.min(s.length(), Math.max(start, end));
                    return s.substring(start, end);
                }
                return s.substring(start);
            }
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Slice.DOCUMENTATION", "If <code>o</code> is an array, returns an array containing the items between <code>from</code> and <code>to</code> (excluded).<br/>If <code>o</code> is a string, returns the part of the string between <code>from</code> and <code>to</code> (excluded).<br/>Omitting the optional number *to* will return the remainder of the string or array.").withParams("o, number from, [number to]").withReturns("GREL.FUNCTIONS.RETURNS.DEPENDS_ON_ARGUMENTS", "depends on arguments").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("[1,2,3,4,5]", "1", "4").returns("[2,3,4]")).withExample(Example.with("\"hello\"", "2", "5").returns("\"llo\""));
    }
}

