/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.geo;

import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.locationtech.jts.geom.Geometry;

public class GeoEnvelope
implements Function {
    private static final GeometryMeaning geometryMeaning = new GeometryMeaning();

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 1) {
            Object geometry = args[0];
            if (geometry instanceof String && !StringUtils.isBlank((String)((String)geometry))) {
                Geometry parsedGeometry = geometryMeaning.toGeometry((String)geometry);
                if (parsedGeometry != null) {
                    Geometry envelope = parsedGeometry.getEnvelope();
                    if (envelope == null) {
                        return new EvalError("Failed to create the envelope");
                    }
                    return envelope.toString();
                }
                return new EvalError("geometry parameter doesn't contain geospatial data");
            }
            return null;
        }
        return new EvalError(String.format("%s requires one argument)", GrelControlFunctionRegistry.getInstance().getFunctionName(this)));
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.GeoEnvelope.DOCUMENTATION", "Returns a Geometry representing the envelope (bounding box) of this Geometry.").withParams("string geometry").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.GEO", "Geo functions").withExample(Example.with("POLYGON((0 0,3 0,0 3,0 0))").returns("POLYGON ((0 0, 0 3, 3 3, 3 0, 0 0))")).withExample(Example.with("polygonColumn").returns("a column of polygons whose vertices are (minx miny, minx maxy, maxx maxy, maxx miny, minx miny)"));
    }
}

