/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class SplitByLengths
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length >= 2 && args[0] != null) {
            Object o = args[0];
            String s = o instanceof String ? (String)o : o.toString();
            String[] results = new String[args.length - 1];
            int lastIndex = 0;
            for (int i = 1; i < args.length; ++i) {
                int thisIndex = lastIndex;
                Object o2 = args[i];
                if (o2 instanceof Number) {
                    thisIndex = Math.min(s.length(), lastIndex + Math.max(0, ((Number)o2).intValue()));
                }
                results[i - 1] = s.substring(lastIndex, thisIndex);
                lastIndex = thisIndex;
            }
            return results;
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects 1 string and 1 or more numbers");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.SplitByLengths.DOCUMENTATION", "Returns the array of strings obtained by splitting a string into substrings with the given lengths.").withParams("string s, number length1 ...").withReturns("array").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"Hello world\"", "1", "2", "3", "4").returns("[\"H\",\"el\",\"lo \",\"worl\"]"));
    }
}

