/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.notifications.common;

import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.notifications.NotificationContextUtils;
import com.dataiku.gh.core.models.notifications.PermissionProtectedTemplateContext;
import com.dataiku.gh.core.models.notifications.TemplateContext;
import com.dataiku.gh.core.models.notifications.common.FeedbackTemplateContext;
import com.dataiku.gh.core.models.notifications.common.UserTemplateContext;
import com.dataiku.gh.core.models.notifications.signoff.SignoffGroupData;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffFeedback;
import com.dataiku.gh.core.models.signoff.SignoffUsersGroup;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SignoffTemplateContext
extends PermissionProtectedTemplateContext {
    private final Signoff signoff;
    private final Map<String, List<SignoffUsersGroup>> groupsPerUser;
    private final Set<String> approvers;
    private final Map<String, List<FeedbackTemplateContext>> feedbackTemplateContexts;
    private final UserTemplateContext approverUserTemplateContext;

    public SignoffTemplateContext(EnrichedArtifact enrichedArtifact, Signoff signoff, SignoffGroupData groupData) {
        super(enrichedArtifact);
        this.signoff = signoff;
        this.groupsPerUser = groupData.groupsPerUser;
        this.approvers = groupData.approvers;
        this.feedbackTemplateContexts = new HashMap<String, List<FeedbackTemplateContext>>();
        if (signoff.feedbackResponses != null) {
            for (SignoffFeedback feedback : signoff.feedbackResponses) {
                List list = this.feedbackTemplateContexts.computeIfAbsent(feedback.groupId, grpId -> new ArrayList());
                list.add(new FeedbackTemplateContext(enrichedArtifact, feedback, signoff.configuration));
            }
        }
        this.approverUserTemplateContext = signoff.approverResponse != null ? new UserTemplateContext(signoff.approverResponse.user) : null;
    }

    public List<TemplateContext> getChildren() {
        ArrayList<TemplateContext> children = new ArrayList<TemplateContext>();
        this.feedbackTemplateContexts.forEach((groupId, list) -> children.addAll((Collection<TemplateContext>)list));
        if (this.approverUserTemplateContext != null) {
            children.add(this.approverUserTemplateContext);
        }
        return children;
    }

    public SimpleHash buildTemplateModel() {
        if (!this.userCanSeeContext()) {
            return null;
        }
        SimpleHash data = new SimpleHash((ObjectWrapper)WRAPPER_BUILDER.build());
        SignoffConfiguration signoffConfiguration = this.signoff.configuration;
        data.put("title", (Object)signoffConfiguration.title);
        data.put("stepId", (Object)signoffConfiguration.id.stepId);
        SimpleHash feedbackMap = new SimpleHash((ObjectWrapper)WRAPPER_BUILDER.build());
        this.feedbackTemplateContexts.forEach((groupId, list) -> feedbackMap.put(groupId, list.stream().map(FeedbackTemplateContext::buildTemplateModel).collect(Collectors.toList())));
        data.put("feedbackResponses", (Object)feedbackMap);
        if (this.signoff.approverResponse != null) {
            SimpleHash approvalLookup = new SimpleHash((ObjectWrapper)WRAPPER_BUILDER.build());
            approvalLookup.put("user", (Object)this.approverUserTemplateContext.buildTemplateModel());
            approvalLookup.put("comment", (Object)this.signoff.approverResponse.comment);
            approvalLookup.put("status", (Object)this.signoff.approverResponse.status.toString());
            approvalLookup.put("creationDate", (Object)NotificationContextUtils.parseDate(this.signoff.approverResponse.creationDate));
            if (StringUtils.isNotBlank((CharSequence)this.signoff.approverResponse.editionDate)) {
                approvalLookup.put("editionDate", (Object)NotificationContextUtils.parseDate(this.signoff.approverResponse.editionDate));
            }
            data.put("approverResponse", (Object)approvalLookup);
        }
        List userGroupTitles = this.groupsPerUser.getOrDefault(this.userLogin, Collections.emptyList()).stream().map(group -> group.title).collect(Collectors.toList());
        data.put("userGroups", userGroupTitles);
        data.put("userIsApprover", this.approvers.contains(this.userLogin));
        return data;
    }
}

