/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflow;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflowStep;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.StepDefinition;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.bool.StoredBooleanFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.category.StoredCategoryFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.date.StoredDateFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.file.StoredUploadedFileFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.json.StoredJsonFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.number.StoredNumberFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.StoredReferenceFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.text.StoredTextFieldDefinition;
import com.dataiku.gh.core.services.artifacts.IArtifactWorkflowService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.DateUtils;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.core.visitors.IEnrichedArtifactVisitor;
import com.dataiku.gh.core.visitors.IFieldAndListValueVisitor;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ArtifactValidator
implements IEnrichedArtifactVisitor {
    private final EnrichedArtifact enrichedArtifact;
    private final EnrichedArtifact previousEnrichedArtifact;
    private final IArtifactWorkflowService artifactWorkflowService;

    public ArtifactValidator(EnrichedArtifact enrichedArtifact, @Nullable EnrichedArtifact previousEnrichedArtifact, IArtifactWorkflowService artifactWorkflowService) {
        this.enrichedArtifact = enrichedArtifact;
        this.previousEnrichedArtifact = previousEnrichedArtifact;
        this.artifactWorkflowService = artifactWorkflowService;
    }

    @Override
    public void visit(EnrichedArtifact enrichedArtifact) {
        Set stepIdsWithMultipleSignoffs = enrichedArtifact.signoffs.stream().collect(Collectors.groupingBy(signoff -> signoff.signoffId.stepId, Collectors.summingInt(signoff -> 1))).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        ValidatorUtils.validateThat(stepIdsWithMultipleSignoffs.isEmpty(), "Only one sign-off is possible per step. Step Ids with multiple sign-offs: %s", stepIdsWithMultipleSignoffs);
        List<StepDefinition> visibleStepsWithBlockingSignoffs = this.artifactWorkflowService.visibleStepsWithBlockingSignoffs(enrichedArtifact);
        Set finishedBlockingSteps = visibleStepsWithBlockingSignoffs.stream().filter(stepDefinition -> Optional.ofNullable(enrichedArtifact.artifact.workflow.steps.get(stepDefinition.id)).map(ArtifactWorkflowStep::isFinished).orElse(false)).map(step -> step.id).collect(Collectors.toSet());
        ValidatorUtils.validateThat(finishedBlockingSteps.isEmpty(), "You cannot set steps as finished if the corresponding final approval is mandatory but its status is not \"Approved\". Unvalidated Step Ids : %s", finishedBlockingSteps);
        Set skippedBlockingSteps = visibleStepsWithBlockingSignoffs.stream().filter(stepDefinition -> Optional.ofNullable(enrichedArtifact.artifact.workflow.steps.get(stepDefinition.id)).map(ArtifactWorkflowStep::isSkipped).orElse(false)).filter(stepDefinition -> this.previousEnrichedArtifact == null || Optional.ofNullable(this.previousEnrichedArtifact.artifact.workflow.steps.get(stepDefinition.id)).map(ArtifactWorkflowStep::isSkipped).orElse(false) == false).map(step -> step.id).collect(Collectors.toSet());
        ValidatorUtils.validateThat(skippedBlockingSteps.isEmpty(), "You cannot have newly skipped steps if the corresponding final approval is mandatory but its status is not \"Approved\". Unvalidated Step Ids : %s", skippedBlockingSteps);
    }

    @Override
    public void visit(ArtifactWorkflow artifactWorkflow) {
        List ongoingSteps = artifactWorkflow.steps.entrySet().stream().filter(e -> ((ArtifactWorkflowStep)e.getValue()).isOngoing()).map(Map.Entry::getKey).collect(Collectors.toList());
        ValidatorUtils.validateThat(ongoingSteps.size() <= 1, "Invalid workflow state: multiple steps ONGOING: " + String.valueOf(ongoingSteps), new Object[0]);
        artifactWorkflow.steps.entrySet().stream().forEach(artifactWorkflowStepEntry -> ValidatorUtils.validateThat(((ArtifactWorkflowStep)artifactWorkflowStepEntry.getValue()).status != null, "Invalid workflow state for step " + (String)artifactWorkflowStepEntry.getKey() + ": status is null", new Object[0]));
        if (!ongoingSteps.isEmpty()) {
            Set<String> visibleStepIds = this.artifactWorkflowService.computeVisibleArtifactWorkflowStepIds(this.enrichedArtifact);
            ValidatorUtils.validateThat(visibleStepIds.contains(ongoingSteps.get(0)), "Invalid workflow state: step " + (String)ongoingSteps.get(0) + " is ongoing but not visible", new Object[0]);
        }
        String furthestFinishedStepId = this.enrichedArtifact.getFurthestFinishedStepId();
        HashSet<String> requiredSteps = new HashSet<String>();
        if (furthestFinishedStepId != null) {
            for (StepDefinition stepDefinition : this.enrichedArtifact.blueprintVersion.workflowDefinition.stepDefinitions) {
                if (stepDefinition.id.equals(furthestFinishedStepId)) break;
                requiredSteps.add(stepDefinition.id);
            }
        }
        Set allSteps = this.enrichedArtifact.blueprintVersion.workflowDefinition.stepDefinitions.stream().map(sd -> sd.id).collect(Collectors.toSet());
        Set<String> givenSteps = artifactWorkflow.steps.keySet();
        HashSet missingSteps = new HashSet(requiredSteps);
        missingSteps.removeAll(givenSteps);
        ValidatorUtils.validateThat(missingSteps.isEmpty(), "Invalid workflow state : missing step status for stepId: " + String.valueOf(missingSteps), new Object[0]);
        HashSet<String> exceedingSteps = new HashSet<String>(givenSteps);
        exceedingSteps.removeAll(allSteps);
        ValidatorUtils.validateThat(exceedingSteps.isEmpty(), "Invalid workflow state : unknown stepId: " + String.valueOf(exceedingSteps), new Object[0]);
    }

    @Override
    public void visit(BlueprintVersion blueprintVersion) {
        if (!IdentifiersUtils.isValidArtifactId(this.enrichedArtifact.artifact.id)) {
            throw new ValidationException("Invalid artifact ID: " + this.enrichedArtifact.artifact.id);
        }
        if (StringUtils.isBlank((CharSequence)this.enrichedArtifact.artifact.name)) {
            throw new ValidationException("Artifact name is required for artifact with id: " + this.enrichedArtifact.artifact.id);
        }
        List invalidArtifactFieldsList = this.enrichedArtifact.artifact.fields.keySet().stream().filter(fieldName -> !blueprintVersion.fieldDefinitions.containsKey(fieldName)).collect(Collectors.toList());
        if (!invalidArtifactFieldsList.isEmpty()) {
            throw new ValidationException("Some fields of Artifact with id `" + this.enrichedArtifact.artifact.id + "` were not found in its blueprint version reference `" + String.valueOf(blueprintVersion.id) + "`. Field names: " + String.join((CharSequence)", ", invalidArtifactFieldsList));
        }
    }

    @Override
    public void visit(StoredBooleanFieldDefinition fieldDefinition, String fieldId) {
        Object fieldValue = this.enrichedArtifact.artifact.fields.get(fieldId);
        this.validateField(fieldId, fieldValue, fieldDefinition, new FieldValidator(){

            @Override
            public void visit(Boolean fieldValue) {
            }
        });
    }

    @Override
    public void visit(final StoredCategoryFieldDefinition fieldDefinition, final String fieldId) {
        Object fieldValue = this.enrichedArtifact.artifact.fields.get(fieldId);
        this.validateField(fieldId, fieldValue, fieldDefinition, new FieldValidator(){

            @Override
            public void visit(String fieldValue) {
                if (StringUtils.isNotBlank((CharSequence)fieldValue) && fieldDefinition.categories != null && !fieldDefinition.categories.contains(fieldValue)) {
                    throw new ValidationException("'" + fieldValue + "' for field ID '" + fieldId + "' is not a valid category for artifact `" + ArtifactValidator.this.enrichedArtifact.artifact.id + "`");
                }
            }
        });
    }

    @Override
    public void visit(StoredDateFieldDefinition fieldDefinition, final String fieldId) {
        Object fieldValue = this.enrichedArtifact.artifact.fields.get(fieldId);
        this.validateField(fieldId, fieldValue, fieldDefinition, new FieldValidator(){

            @Override
            public void visit(String fieldValue) {
                ValidatorUtils.validateThat(DateUtils.isValidDateString(fieldValue), "Field ID `" + fieldId + "` has incorrect ISO date format `" + fieldValue + "` for artifact `" + ArtifactValidator.this.enrichedArtifact.artifact.id + "`", new Object[0]);
            }
        });
    }

    @Override
    public void visit(final StoredNumberFieldDefinition fieldDefinition, final String fieldId) {
        Object fieldValue = this.enrichedArtifact.artifact.fields.get(fieldId);
        this.validateField(fieldId, fieldValue, fieldDefinition, new FieldValidator(){

            @Override
            public void visit(Double fieldValue) {
                if (fieldDefinition.min != null && fieldValue != null && fieldValue < fieldDefinition.min) {
                    throw new ValidationException("Input value of field `" + fieldId + "` is below min `" + fieldDefinition.min + "` for artifact `" + ArtifactValidator.this.enrichedArtifact.artifact.id + "`");
                }
                if (fieldDefinition.max != null && fieldValue != null && fieldValue > fieldDefinition.max) {
                    throw new ValidationException("Input value of field `" + fieldId + "` is above max `" + fieldDefinition.max + "` for artifact `" + ArtifactValidator.this.enrichedArtifact.artifact.id + "`");
                }
            }
        });
    }

    @Override
    public void visit(StoredReferenceFieldDefinition fieldDefinition, String fieldId) {
        Object fieldValue = this.enrichedArtifact.artifact.fields.get(fieldId);
        this.validateField(fieldId, fieldValue, fieldDefinition, new FieldValidator(){

            @Override
            public void visit(String fieldValue) {
            }
        });
    }

    @Override
    public void visit(final StoredTextFieldDefinition fieldDefinition, final String fieldId) {
        Object fieldValue = this.enrichedArtifact.artifact.fields.get(fieldId);
        this.validateField(fieldId, fieldValue, fieldDefinition, new FieldValidator(){

            @Override
            public void visit(String fieldValue) {
                if (fieldDefinition.required && StringUtils.isBlank((CharSequence)fieldValue)) {
                    throw new ValidationException("Field with ID '" + fieldId + "' is required for artifact: " + ArtifactValidator.this.enrichedArtifact.artifact.id);
                }
            }
        });
    }

    @Override
    public void visit(StoredUploadedFileFieldDefinition fieldDefinition, String fieldId) {
        Object fieldValue = this.enrichedArtifact.artifact.fields.get(fieldId);
        this.validateField(fieldId, fieldValue, fieldDefinition, new FieldValidator(){

            @Override
            public void visit(String fieldValue) {
            }
        });
    }

    @Override
    public void visit(final StoredJsonFieldDefinition fieldDefinition, final String fieldId) {
        Object fieldValue = this.enrichedArtifact.artifact.fields.get(fieldId);
        this.validateField(fieldId, fieldValue, fieldDefinition, new FieldValidator(){

            @Override
            public void visit(Map<String, Object> fieldValue) {
                if (!fieldValue.containsKey("value")) {
                    throw new ValidationException("'" + String.valueOf(fieldValue) + "' for field ID '" + fieldId + "' does not contain member 'value' for artifact `" + ArtifactValidator.this.enrichedArtifact.artifact.id + "`");
                }
                if (fieldValue.get("value") instanceof String) {
                    String jsonValue = (String)fieldValue.get("value");
                    if (fieldDefinition.required && StringUtils.isBlank((CharSequence)jsonValue)) {
                        throw new ValidationException("Field with ID '" + fieldId + "' is required for artifact: " + ArtifactValidator.this.enrichedArtifact.artifact.id);
                    }
                    try {
                        JSON.parse((String)jsonValue, JsonElement.class);
                    }
                    catch (JsonSyntaxException e) {
                        throw new ValidationException("JSON value for field ID '" + fieldId + "' is not a valid JSON string", e);
                    }
                } else {
                    throw new ValidationException("JSON value for field ID '" + fieldId + "' should be a string");
                }
            }
        });
    }

    private void validateField(final String fieldId, Object fieldValue, final FieldDefinition fieldDefinition, FieldValidator validator) {
        if (fieldDefinition.required && fieldValue == null) {
            throw new ValidationException("Field `" + fieldId + "` value is required for artifact: " + this.enrichedArtifact.artifact.id);
        }
        if (fieldValue != null) {
            FieldDefinition.ListConfig listConfig;
            if (!(fieldValue instanceof List) && (listConfig = fieldDefinition.listConfig) != null) {
                throw new ValidationException("Field `" + fieldId + "` is a list in artifact: " + this.enrichedArtifact.artifact.id);
            }
            validator.visit(fieldValue);
        }
        new IFieldAndListValueVisitor(){

            @Override
            public void visit(List<Object> fieldValue) {
                int size = fieldValue.size();
                FieldDefinition.ListConfig listConfig = fieldDefinition.listConfig;
                if (listConfig == null) {
                    throw new ValidationException("Field `" + fieldId + "` is not a list in artifact: " + ArtifactValidator.this.enrichedArtifact.artifact.id);
                }
                if (listConfig.cardinalityMin != null && size < listConfig.cardinalityMin) {
                    throw new ValidationException("Field `" + fieldId + "` size is lower than the minimum allowed: " + listConfig.cardinalityMin + " in artifact: " + ArtifactValidator.this.enrichedArtifact.artifact.id);
                }
                if (listConfig.cardinalityMax != null && size > listConfig.cardinalityMax) {
                    throw new ValidationException("Field `" + fieldId + "` size is greater than the maximum allowed: " + listConfig.cardinalityMax + " in artifact: " + ArtifactValidator.this.enrichedArtifact.artifact.id);
                }
            }
        }.visit(fieldValue);
    }

    private class FieldValidator
    implements IFieldAndListValueVisitor {
        private FieldValidator() {
        }

        @Override
        public void visit(Boolean fieldValue) {
            throw new ValidationException("Invalid type for field value: boolean in artifact: " + ArtifactValidator.this.enrichedArtifact.artifact.id);
        }

        @Override
        public void visit(Double fieldValue) {
            throw new ValidationException("Invalid type for field value: double in artifact: " + ArtifactValidator.this.enrichedArtifact.artifact.id);
        }

        @Override
        public void visit(String fieldValue) {
            throw new ValidationException("Invalid type for field value: string in artifact: " + ArtifactValidator.this.enrichedArtifact.artifact.id);
        }

        @Override
        public void visit(Map<String, Object> fieldValue) {
            throw new ValidationException("Invalid type for field value: map in artifact: " + ArtifactValidator.this.enrichedArtifact.artifact.id);
        }
    }
}

