/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.artifacts.relationships;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.relationships.ReferenceRelationship;
import com.dataiku.gh.core.storage.artifacts.IReferenceRelationshipDAO;
import com.dataiku.gh.core.storage.sql.AbstractSQLRelationshipDAO;
import com.dataiku.gh.core.storage.sql.artifacts.relationships.ReferenceRelationshipsRowMapper;
import com.dataiku.gh.core.storage.sql.model.QArtifacts;
import com.dataiku.gh.core.storage.sql.model.QReferenceRelationships;
import com.dataiku.gh.core.storage.sql.model.QReferenceRelationshipsHistory;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLInsertClause;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ReferenceRelationshipDAO
extends AbstractSQLRelationshipDAO<ReferenceRelationship>
implements IReferenceRelationshipDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.artifacts.relationships");
    @Autowired
    private ReferenceRelationshipsRowMapper referenceRelationshipsRowMapper;

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected EntityType getEntityType() {
        return EntityType.REFERENCE_RELATIONSHIP;
    }

    @Override
    protected void sqlCreateRevision(ReferenceRelationship referenceRelationship, HistoryRevision revision) throws DataStoreIOException {
        SQLInsertClause insertHistory = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QReferenceRelationshipsHistory.referenceRelationshipsHistory).set(QReferenceRelationshipsHistory.referenceRelationshipsHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QReferenceRelationshipsHistory.referenceRelationshipsHistory.referenceRelationshipJson, QueryBuilderUtils.toJsonb(referenceRelationship));
        int ret = this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insertHistory);
        if (ret != 1) {
            throw new DataStoreIOException("Cannot create history item");
        }
    }

    @Override
    protected RelationalPath<?> getRelationshipTable() {
        return QReferenceRelationships.referenceRelationships;
    }

    @Override
    protected RelationalPath<?> getEntityTable() {
        return QArtifacts.artifacts;
    }

    @Override
    protected StringExpression getEntityKey() {
        return QArtifacts.artifacts.artifactId;
    }

    @Override
    protected StringExpression getRelationshipEntityKey() {
        return QReferenceRelationships.referenceRelationships.referenceRelationshipArtifactIdTo;
    }

    @Override
    protected StringExpression getArtifactIdKey() {
        return QReferenceRelationships.referenceRelationships.referenceRelationshipArtifactIdFrom;
    }

    @Override
    protected SimplePath<Object> getRelationshipJson() {
        return QReferenceRelationships.referenceRelationships.referenceRelationshipJson;
    }

    @Override
    protected RowMapper<ReferenceRelationship> getRowMapper() {
        return this.referenceRelationshipsRowMapper;
    }
}

