/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.auth;

import com.dataiku.common.server.APIKeyBase;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dip.util.CachedJSONFile;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.model.serverconfig.AdminAPIKey;
import com.dataiku.lambda.model.serverconfig.LambdaServerAdminAuthConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AdminAuthCRUDService {
    @Autowired
    private LambdaContext lmContext;
    CachedJSONFile<LambdaServerConfig> serverConfigFile;
    CachedJSONFile<LambdaServerAdminAuthConfig> authConfigFile;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.apinode.auth.service");

    @PostConstruct
    public void init() {
        this.serverConfigFile = new CachedJSONFile(this.lmContext.getFile(new String[]{"config/server.json"}), LambdaServerConfig.class);
        this.authConfigFile = new CachedJSONFile(this.lmContext.getFile(new String[]{"config/adminkeys.json"}), LambdaServerAdminAuthConfig.class);
    }

    public synchronized List<AdminAPIKey> listKeys() throws IOException {
        List keys = ((LambdaServerAdminAuthConfig)this.authConfigFile.get()).keys;
        if (ApiKeyUtils.useHashedApiKeys()) {
            keys.forEach(APIKeyBase::redactKeySecret);
        }
        return keys.stream().filter(key -> !key.isManagedKey()).collect(Collectors.toList());
    }

    public synchronized AdminAPIKey createAdminKey(AdminAPIKey newKey) throws IOException {
        LambdaServerAdminAuthConfig authConfig = (LambdaServerAdminAuthConfig)this.authConfigFile.get();
        if (StringUtils.isBlank((String)newKey.key)) {
            newKey.key = ApiKeyUtils.generateApiKeySecret();
        }
        newKey.id = SecretKeyGenerator.generate((int)16);
        newKey.createdOn = System.currentTimeMillis();
        newKey.managedKey = false;
        AdminAPIKey keyCopy = newKey.deepCopy();
        keyCopy.key = ApiKeyUtils.hashIfNecessary((String)keyCopy.key);
        authConfig.keys.add(keyCopy);
        this.authConfigFile.write((Object)authConfig);
        return newKey;
    }

    public void deleteAdminKeyByKey(String keyKey) throws IOException {
        logger.info((Object)"Removing admin key");
        this.deleteAdminKey(key -> ApiKeyUtils.compareKeySecret((String)keyKey, (String)key.key));
    }

    public void deleteAdminKeyById(String keyId) throws IOException {
        if (keyId == null) {
            throw new IllegalArgumentException("Key ID must not be null");
        }
        logger.info((Object)("Removing admin key with id: " + keyId));
        this.deleteAdminKey(key -> keyId.equals(key.id));
    }

    private synchronized void deleteAdminKey(Predicate<AdminAPIKey> keyFilter) throws IOException {
        LambdaServerAdminAuthConfig authConfig = (LambdaServerAdminAuthConfig)this.authConfigFile.get();
        int foundIdx = -1;
        for (int i = 0; i < authConfig.keys.size(); ++i) {
            AdminAPIKey _fk = (AdminAPIKey)authConfig.keys.get(i);
            if (_fk.isManagedKey() || !keyFilter.test(_fk)) continue;
            foundIdx = i;
            break;
        }
        if (foundIdx == -1) {
            throw ErrorContext.iae((String)"Key to delete not found");
        }
        authConfig.keys.remove(foundIdx);
        this.authConfigFile.write((Object)authConfig);
    }
}

