/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.auth;

import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.auth.APIAuthUtils;
import com.dataiku.dip.security.jwt.JwtVerificationService;
import com.dataiku.dip.util.HashUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.auth.ApiKeyAuthMethod;
import com.dataiku.lambda.auth.AuthMethod;
import com.dataiku.lambda.auth.OAuth2AuthMethod;
import com.dataiku.lambda.auth.PublicAuthMethod;
import com.dataiku.lambda.model.serverconfig.LambdaAuthMethod;
import com.dataiku.lambda.model.serverconfig.LambdaServiceConfig;
import com.dataiku.lambda.model.serverconfig.QueryAPIKey;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthVerificationService {
    public static final String AUDIT_LOG_REF_SECURITY_ACCESS = "securityAccess";
    public static final String AUDIT_LOG_REF_SERVICE_ID = "service";
    private static final String AUDIT_LOG_IS_QUERIED_THROUGH_DEPLOYER = "isQueriedThroughDeployer";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.apinode.auth.service");
    @Autowired
    PasswordEncryptionService passwordEncryptionService;
    @Autowired
    JwtVerificationService jwtVerificationService;

    public void checkAuth(String serviceId, LambdaServiceConfig serviceConfig, HttpServletRequest req) throws NotAuthenticatedException, UnauthorizedException {
        AuditContextBase.addCustom((String)AUDIT_LOG_REF_SECURITY_ACCESS, (String)serviceConfig.getAuthMethod().name());
        AuditContextBase.addCustom((String)AUDIT_LOG_REF_SERVICE_ID, (String)serviceId);
        if (this.isQueriedThroughDeployer(req, serviceConfig.deployerKeyHash)) {
            logger.debug(() -> "Query submitted using the query-through-deployer API key");
            AuditContextBase.addCustom((String)AUDIT_LOG_IS_QUERIED_THROUGH_DEPLOYER, (String)"true");
            return;
        }
        this.getAuthMethod(serviceId, serviceConfig).validate(req);
    }

    private AuthMethod<QueryAPIKey> getAuthMethod(String serviceId, LambdaServiceConfig serviceConfig) {
        return switch (serviceConfig.getAuthMethod()) {
            case LambdaAuthMethod.PUBLIC -> new PublicAuthMethod();
            case LambdaAuthMethod.OAUTH2 -> new OAuth2AuthMethod(this.jwtVerificationService, serviceId, serviceConfig.oauth2Config);
            default -> new ApiKeyAuthMethod(this.apiKeyValidationFunction(serviceConfig.authRealm.queryKeys));
        };
    }

    private Function<String, Optional<QueryAPIKey>> apiKeyValidationFunction(List<QueryAPIKey> realmQueryKeys) {
        return apiKey -> realmQueryKeys.stream().filter(queryKey -> {
            String decryptedKey = this.passwordEncryptionService.decryptIfEncrypted(queryKey.key);
            return decryptedKey.equals(apiKey);
        }).findAny();
    }

    public QueryAPIKey getApiKeyForInternalCalls(String serviceId, LambdaServiceConfig serviceConfig, HttpServletRequest req) {
        return this.getAuthMethod(serviceId, serviceConfig).getApiKeyForInternalCalls(req);
    }

    public boolean isQueriedThroughDeployer(HttpServletRequest request, @Nullable String deployerKeyHash) {
        if (deployerKeyHash == null) {
            return false;
        }
        try {
            String reqApiKey = APIAuthUtils.extractApiKey((HttpServletRequest)request);
            if (StringUtils.isBlank((String)reqApiKey)) {
                return false;
            }
            return HashUtils.verifySha256((String)reqApiKey, (String)deployerKeyHash);
        }
        catch (NotAuthenticatedException e) {
            return false;
        }
        catch (Exception e) {
            logger.trace(() -> "Could not verify if the query was made from the deployer : " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

