/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.monitoring;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;

public class JSONTimer {
    public long count;
    public double max;
    public double mean;
    public double min;
    public double p50;
    public double p75;
    public double p95;
    public double p98;
    public double p99;
    public double p999;
    public double stddev;
    public double m15_rate;
    public double m1_rate;
    public double m5_rate;
    public double mean_rate;

    public JSONTimer() {
    }

    public JSONTimer(Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        this.count = timer.getCount();
        this.max = snapshot.getMax() / 1000L;
        this.mean = snapshot.getMean() / 1000.0;
        this.min = snapshot.getMin() / 1000L;
        this.p50 = snapshot.getMedian() / 1000.0;
        this.p75 = snapshot.get75thPercentile() / 1000.0;
        this.p95 = snapshot.get95thPercentile() / 1000.0;
        this.p98 = snapshot.get98thPercentile() / 1000.0;
        this.p99 = snapshot.get99thPercentile() / 1000.0;
        this.p999 = snapshot.get999thPercentile() / 1000.0;
        this.stddev = snapshot.getStdDev() / 1000.0;
        this.m15_rate = timer.getFifteenMinuteRate();
        this.m5_rate = timer.getFiveMinuteRate();
        this.m1_rate = timer.getOneMinuteRate();
        this.mean_rate = timer.getMeanRate();
    }
}

