/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id;

import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Identifier;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.StringUtils;
import com.dataiku.dss.shadelib.net.jcip.annotations.Immutable;
import java.net.URI;
import java.net.URISyntaxException;

@Immutable
public final class Issuer
extends Identifier {
    private static final long serialVersionUID = -8033463330193076151L;

    public static boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        try {
            return Issuer.isValid(new URI(value));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isValid(Issuer value) {
        if (value == null) {
            return false;
        }
        try {
            return Issuer.isValid(new URI(value.getValue()));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isValid(URI value) {
        if (value == null) {
            return false;
        }
        if (value.getScheme() == null || !value.getScheme().equalsIgnoreCase("https")) {
            return false;
        }
        if (value.getRawQuery() != null) {
            return false;
        }
        return value.getRawFragment() == null;
    }

    public Issuer(String value) {
        super(value);
    }

    public Issuer(URI value) {
        super(value.toString());
    }

    public Issuer(Identifier value) {
        super(value.getValue());
    }

    public boolean isValid() {
        return Issuer.isValid(this);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Issuer && this.toString().equals(object.toString());
    }

    public static Issuer parse(String s2) {
        if (StringUtils.isBlank(s2)) {
            return null;
        }
        return new Issuer(s2);
    }
}

