/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.io.swagger.deserializer;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.DeserializationFeature;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonMappingException;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelib.io.swagger.deserializer.SwaggerDeserializer;
import com.dataiku.dss.shadelib.io.swagger.report.Message;
import com.dataiku.dss.shadelib.io.swagger.report.MessageBuilder;
import com.dataiku.dss.shadelib.io.swagger.report.Severity;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;

public abstract class AbstractSwaggerDeserializer<T>
implements SwaggerDeserializer<T> {
    protected final Class<T> clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    protected final ObjectMapper objectMapper = new ObjectMapper();

    protected AbstractSwaggerDeserializer() {
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
    }

    @Override
    public T deserialize(JsonNode jsonNode, MessageBuilder messageBuilder) {
        T deserializedObject = null;
        try {
            deserializedObject = this.objectMapper.readValue(jsonNode.traverse(), this.clazz);
        }
        catch (JsonMappingException e) {
            messageBuilder.append(new Message(e.getPathReference(), e.getMessage(), Severity.ERROR));
        }
        catch (IOException e) {
            messageBuilder.append(new Message("", e.getMessage(), Severity.ERROR));
        }
        return deserializedObject;
    }
}

