/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.commons.beanutils;

import com.dataiku.dss.shadelib.org.apache.commons.beanutils.BeanIntrospector;
import com.dataiku.dss.shadelib.org.apache.commons.beanutils.IntrospectionContext;
import com.dataiku.dss.shadelib.org.apache.commons.logging.Log;
import com.dataiku.dss.shadelib.org.apache.commons.logging.LogFactory;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Locale;

public class FluentPropertyBeanIntrospector
implements BeanIntrospector {
    public static final String DEFAULT_WRITE_METHOD_PREFIX = "set";
    private final Log log = LogFactory.getLog(this.getClass());
    private final String writeMethodPrefix;

    public FluentPropertyBeanIntrospector() {
        this(DEFAULT_WRITE_METHOD_PREFIX);
    }

    public FluentPropertyBeanIntrospector(String writePrefix) {
        if (writePrefix == null) {
            throw new IllegalArgumentException("Prefix for write methods must not be null!");
        }
        this.writeMethodPrefix = writePrefix;
    }

    private PropertyDescriptor createFluentPropertyDescritor(Method m4, String propertyName) throws IntrospectionException {
        return new PropertyDescriptor(this.propertyName(m4), null, m4);
    }

    public String getWriteMethodPrefix() {
        return this.writeMethodPrefix;
    }

    @Override
    public void introspect(IntrospectionContext icontext) throws IntrospectionException {
        for (Method m4 : icontext.getTargetClass().getMethods()) {
            if (!m4.getName().startsWith(this.getWriteMethodPrefix())) continue;
            String propertyName = this.propertyName(m4);
            PropertyDescriptor pd = icontext.getPropertyDescriptor(propertyName);
            try {
                if (pd == null) {
                    icontext.addPropertyDescriptor(this.createFluentPropertyDescritor(m4, propertyName));
                    continue;
                }
                if (pd.getWriteMethod() != null) continue;
                PropertyDescriptor fluentPropertyDescriptor = new PropertyDescriptor(pd.getName(), pd.getReadMethod(), m4);
                icontext.addPropertyDescriptor(fluentPropertyDescriptor);
            }
            catch (IntrospectionException e) {
                this.log.info("Error when creating PropertyDescriptor for " + m4 + "! Ignoring this property.");
                this.log.debug("Exception is:", e);
            }
        }
    }

    private String propertyName(Method m4) {
        String methodName = m4.getName().substring(this.getWriteMethodPrefix().length());
        return methodName.length() > 1 ? Introspector.decapitalize(methodName) : methodName.toLowerCase(Locale.ROOT);
    }
}

