/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.email;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.CharArraySet;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.LowerCaseFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.StopFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.StopwordAnalyzerBase;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.email.UAX29URLEmailTokenizer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.en.EnglishAnalyzer;
import java.io.IOException;
import java.io.Reader;

public final class UAX29URLEmailAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;
    public static final CharArraySet STOP_WORDS_SET = EnglishAnalyzer.ENGLISH_STOP_WORDS_SET;

    public UAX29URLEmailAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public UAX29URLEmailAnalyzer() {
        this(STOP_WORDS_SET);
    }

    public UAX29URLEmailAnalyzer(Reader stopwords) throws IOException {
        this(UAX29URLEmailAnalyzer.loadStopwordSet(stopwords));
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        UAX29URLEmailTokenizer src = new UAX29URLEmailTokenizer();
        src.setMaxTokenLength(this.maxTokenLength);
        TokenFilter tok = new LowerCaseFilter(src);
        tok = new StopFilter(tok, this.stopwords);
        return new Analyzer.TokenStreamComponents(r -> {
            src.setMaxTokenLength(this.maxTokenLength);
            src.setReader((Reader)r);
        }, (TokenStream)tok);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }
}

