/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.index;

import com.dataiku.dss.shadelib.org.apache.lucene.store.Directory;
import com.dataiku.dss.shadelib.org.apache.lucene.store.FilterDirectory;
import com.dataiku.dss.shadelib.org.apache.lucene.store.IOContext;
import com.dataiku.dss.shadelib.org.apache.lucene.store.IndexInput;
import com.dataiku.dss.shadelib.org.apache.lucene.store.IndexOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class TrackingTmpOutputDirectoryWrapper
extends FilterDirectory {
    private final Map<String, String> fileNames = new HashMap<String, String>();

    TrackingTmpOutputDirectoryWrapper(Directory in) {
        super(in);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        IndexOutput output = super.createTempOutput(name, "", context);
        this.fileNames.put(name, output.getName());
        return output;
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        String tmpName = this.fileNames.getOrDefault(name, name);
        return super.openInput(tmpName, context);
    }

    public Map<String, String> getTemporaryFiles() {
        return this.fileNames;
    }
}

