/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow.tracking;

import com.dataiku.dss.shadelib.org.mlflow.api.proto.ModelRegistry;
import com.dataiku.dss.shadelib.org.mlflow.tracking.EmptyPage;
import com.dataiku.dss.shadelib.org.mlflow.tracking.MlflowClient;
import com.dataiku.dss.shadelib.org.mlflow.tracking.Page;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ModelVersionsPage
implements Page<ModelRegistry.ModelVersion> {
    private final String token;
    private final List<ModelRegistry.ModelVersion> mvs;
    private final MlflowClient client;
    private final String searchFilter;
    private final List<String> orderBy;
    private final int maxResults;

    ModelVersionsPage(List<ModelRegistry.ModelVersion> mvs, String token, String searchFilter, int maxResults, List<String> orderBy, MlflowClient client) {
        this.mvs = Collections.unmodifiableList(mvs);
        this.token = token;
        this.searchFilter = searchFilter;
        this.orderBy = orderBy;
        this.maxResults = maxResults;
        this.client = client;
    }

    @Override
    public int getPageSize() {
        return this.mvs.size();
    }

    @Override
    public boolean hasNextPage() {
        return this.token != null && this.token != "";
    }

    @Override
    public Optional<String> getNextPageToken() {
        if (this.hasNextPage()) {
            return Optional.of(this.token);
        }
        return Optional.empty();
    }

    @Override
    public Page<ModelRegistry.ModelVersion> getNextPage() {
        if (this.hasNextPage()) {
            return this.client.searchModelVersions(this.searchFilter, this.maxResults, this.orderBy, this.token);
        }
        return new EmptyPage<ModelRegistry.ModelVersion>();
    }

    @Override
    public List<ModelRegistry.ModelVersion> getItems() {
        return this.mvs;
    }
}

