/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow.tracking.creds;

import com.dataiku.dss.shadelib.org.mlflow.tracking.creds.DatabricksHostCredsProvider;
import com.dataiku.dss.shadelib.org.mlflow.tracking.creds.DatabricksMlflowHostCreds;
import com.dataiku.dss.shadelib.org.mlflow_project.ini4j.Ini;
import com.dataiku.dss.shadelib.org.mlflow_project.ini4j.Profile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;

public class DatabricksConfigHostCredsProvider
extends DatabricksHostCredsProvider {
    private static final String CONFIG_FILE_ENV_VAR = "DATABRICKS_CONFIG_FILE";
    private final String profile;
    private DatabricksMlflowHostCreds hostCreds;

    public DatabricksConfigHostCredsProvider(String profile) {
        this.profile = profile;
    }

    public DatabricksConfigHostCredsProvider() {
        this.profile = null;
    }

    private void loadConfigIfNecessary() {
        if (this.hostCreds == null) {
            this.reloadConfig();
        }
    }

    private void reloadConfig() {
        boolean hasValidToken;
        Profile.Section section;
        Ini ini;
        String basePath = System.getenv(CONFIG_FILE_ENV_VAR);
        if (basePath == null) {
            String userHome = System.getProperty("user.home");
            basePath = Paths.get(userHome, ".databrickscfg").toString();
        }
        if (!new File(basePath).isFile()) {
            throw new IllegalStateException("Could not find Databricks configuration file (" + basePath + "). Please run 'databricks configure' using the Databricks CLI.");
        }
        try {
            ini = new Ini(new File(basePath));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load databrickscfg file at " + basePath, e);
        }
        if (this.profile == null) {
            section = (Profile.Section)ini.get("DEFAULT");
            if (section == null) {
                throw new IllegalStateException("Could not find 'DEFAULT' section within config file (" + basePath + "). Please run 'databricks configure' using the Databricks CLI.");
            }
        } else {
            section = (Profile.Section)ini.get(this.profile);
            if (section == null) {
                throw new IllegalStateException("Could not find '" + this.profile + "' section within config file  (" + basePath + "). Please run 'databricks configure --profile " + this.profile + "' using the Databricks CLI.");
            }
        }
        assert (section != null);
        String host = (String)section.get("host");
        String username = (String)section.get("username");
        String password = (String)section.get("password");
        String token = (String)section.get("token");
        boolean insecure = section.get((Object)"insecure", "false").toLowerCase().equals("true");
        if (host == null) {
            throw new IllegalStateException("No 'host' configured within Databricks config file (" + basePath + "). Please run 'databricks configure' using the Databricks CLI.");
        }
        boolean hasValidUserPassword = username != null && password != null;
        boolean bl = hasValidToken = token != null;
        if (!hasValidUserPassword && !hasValidToken) {
            throw new IllegalStateException("No authentication configured within Databricks config file (" + basePath + "). Please run 'databricks configure' using the Databricks CLI.");
        }
        this.hostCreds = new DatabricksMlflowHostCreds(host, username, password, token, insecure);
    }

    @Override
    public DatabricksMlflowHostCreds getHostCreds() {
        this.loadConfigIfNecessary();
        return this.hostCreds;
    }

    @Override
    public void refresh() {
        this.reloadConfig();
    }
}

