/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.reactor.core.publisher;

import com.dataiku.dss.shadelib.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelib.reactor.core.Exceptions;
import com.dataiku.dss.shadelib.reactor.core.Fuseable;
import com.dataiku.dss.shadelib.reactor.core.Scannable;
import com.dataiku.dss.shadelib.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelib.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelib.reactor.core.publisher.SourceProducer;
import java.time.Duration;
import java.util.Objects;

final class MonoError<T>
extends Mono<T>
implements Fuseable.ScalarCallable,
SourceProducer<T> {
    final Throwable error;

    MonoError(Throwable error) {
        this.error = Objects.requireNonNull(error, "error");
    }

    @Override
    public T block(Duration m4) {
        throw Exceptions.propagate(this.error);
    }

    @Override
    public T block() {
        throw Exceptions.propagate(this.error);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Operators.error(actual, this.error);
    }

    @Override
    public Object call() throws Exception {
        if (this.error instanceof Exception) {
            throw (Exception)this.error;
        }
        throw Exceptions.propagate(this.error);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }
}

