/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring;

import java.io.Serializable;

public class Try<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final T value;
    private final String message;
    private final boolean isError;

    private Try(T value, String message, boolean isError) {
        this.value = value;
        this.message = message;
        this.isError = isError;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isSuccess() {
        return !this.isError;
    }

    public T get() {
        if (this.isError) {
            throw new IllegalStateException("Try is in error state, with message: " + this.message);
        }
        return this.value;
    }

    public String getMessage() {
        return this.message;
    }

    public T orElse(T t) {
        return this.isError ? t : this.value;
    }

    public static <T> Try<T> success(T t) {
        return new Try<T>(t, null, false);
    }

    public static <T> Try<T> failure(String e) {
        if (e == null) {
            throw new IllegalArgumentException("Error message for a failure must not be null.");
        }
        return new Try<Object>(null, e, true);
    }
}

