/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.dss.shadelib.com.google.gson.stream.JsonReader;
import com.dataiku.dss.shadelib.com.google.gson.stream.JsonToken;
import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class UnfoldVectors
implements Processor {
    private static final long serialVersionUID = 0L;
    private final String[] columns;
    private final int[] vectorLengths;

    public UnfoldVectors(String[] columns, int[] vectorLengths) {
        this.columns = columns;
        this.vectorLengths = vectorLengths;
    }

    private String getName(String col, int index) {
        return "unfold:" + col + ":" + index;
    }

    @Override
    public void process(RawObservation data) {
        for (int i = 0; i < this.columns.length; ++i) {
            String col = this.columns[i];
            int vectorLength = this.vectorLengths[i];
            try {
                JsonReader arr = new JsonReader((Reader)new StringReader(data.getAsString(col)));
                arr.setLenient(true);
                arr.beginArray();
                block7: for (int j = 0; j < vectorLength; ++j) {
                    switch (arr.peek()) {
                        case END_ARRAY: {
                            data.setError("Size mismatch for vector column '" + col + "': expected " + vectorLength + ", found: " + j);
                            return;
                        }
                        case NUMBER: {
                            data.put(this.getName(col, j), arr.nextDouble());
                            continue block7;
                        }
                        default: {
                            data.setError("Some element of vector column '" + col + "' are not numbers, found " + String.valueOf(arr.peek()));
                            return;
                        }
                    }
                }
                if (arr.peek() == JsonToken.END_ARRAY) continue;
                data.setError("Size mismatch for vector column '" + col + "': a row exceeds the expected " + vectorLength);
                return;
            }
            catch (IOException | IllegalStateException e) {
                data.setError("Invalid vector data in column '" + col + "': " + e.getMessage());
            }
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("UnfoldVectors(");
        for (int i = 0; i < this.columns.length; ++i) {
            s.append(this.columns[i]).append('[').append(this.vectorLengths[i]).append(']');
            if (i == this.columns.length - 1) continue;
            s.append("; ");
        }
        return s.append(")").toString();
    }
}

