/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.utils.WithParams;

public class BasicCSVFormatConfig {
    int probableNumberOfRecords;
    public String charset = "utf8";
    public char separator;
    public char quoteChar;
    public Character escapeChar;
    public Character arraySeparator;
    public Character mapKeySeparator;
    public String arrayMapFormat = "delimited";
    public int skipRowsBeforeHeader;
    public boolean parseHeaderRow;
    public int skipRowsAfterHeader;

    public BasicCSVFormatConfig() {
    }

    public BasicCSVFormatConfig(WithParams p) {
        this.charset = p.getParam("charset", "utf8");
        this.separator = p.getCharParam("separator");
        this.quoteChar = !p.getParam("quoteChar", "").isEmpty() ? p.getCharParam("quoteChar") : (char)34;
        if (!p.getParam("escapeChar", "").isEmpty()) {
            this.escapeChar = Character.valueOf(p.getCharParam("escapeChar"));
        }
        this.arraySeparator = !p.getParam("arrayItemSeparator", "").isEmpty() ? Character.valueOf(p.getCharParam("arrayItemSeparator")) : Character.valueOf('\u0002');
        this.mapKeySeparator = !p.getParam("mapKeySeparator", "").isEmpty() ? Character.valueOf(p.getCharParam("mapKeySeparator")) : Character.valueOf('\u0003');
        this.arrayMapFormat = !p.getParam("arrayMapFormat", "").isEmpty() ? p.getParam("arrayMapFormat") : "delimited";
        if (!this.arrayMapFormat.equals("json") && !this.arrayMapFormat.equals("delimited")) {
            throw new IllegalArgumentException("arrayMapFormat: possible values are json or delimited");
        }
        this.skipRowsBeforeHeader = p.getIntParam("skipRowsBeforeHeader", Integer.valueOf(0));
        this.parseHeaderRow = p.getBoolParam("parseHeaderRow", true);
        this.skipRowsAfterHeader = p.getIntParam("skipRowsAfterHeader", Integer.valueOf(0));
    }

    public static enum CSVStyle {
        OPENCSV,
        RFC,
        ESCAPE_ONLY_NO_QUOTE;

    }
}

