/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.deletionvectors;

import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.roaringbitmap.RoaringBitmap;

public final class RoaringBitmapArray {
    static final long MAX_REPRESENTABLE_VALUE = RoaringBitmapArray.composeFromHighLowBytes(0x7FFFFFFE, Integer.MIN_VALUE);
    private RoaringBitmap[] bitmaps = new RoaringBitmap[0];

    static int highBytes(long l) {
        return (int)(l >> 32);
    }

    static int lowBytes(long l) {
        return (int)l;
    }

    static long composeFromHighLowBytes(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    static RoaringBitmapArray readFrom(byte[] byArray) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        RoaringBitmapArray roaringBitmapArray = new RoaringBitmapArray();
        roaringBitmapArray.deserialize(byteBuffer);
        return roaringBitmapArray;
    }

    void deserialize(ByteBuffer byteBuffer) throws IOException {
        Preconditions.checkArgument(ByteOrder.LITTLE_ENDIAN == byteBuffer.order(), "RoaringBitmapArray has to be deserialized using a little endian buffer");
        int n = byteBuffer.getInt();
        if (n == 1681511376) {
            this.bitmaps = NativeRoaringBitmapArraySerializationFormat.deserialize(byteBuffer);
        } else if (n == 1681511377) {
            this.bitmaps = PortableRoaringBitmapArraySerializationFormat.deserialize(byteBuffer);
        } else {
            throw new IOException("Unexpected RoaringBitmapArray magic number " + n);
        }
    }

    public boolean contains(long l) {
        Preconditions.checkArgument(l >= 0L && l <= MAX_REPRESENTABLE_VALUE);
        int n = RoaringBitmapArray.highBytes(l);
        if (n >= this.bitmaps.length) {
            return false;
        }
        RoaringBitmap roaringBitmap = this.bitmaps[n];
        int n2 = RoaringBitmapArray.lowBytes(l);
        return roaringBitmap.contains(n2);
    }

    static Tuple2<Integer, Integer> decomposeHighLowBytes(long l) {
        return new Tuple2<Integer, Integer>(RoaringBitmapArray.highBytes(l), RoaringBitmapArray.lowBytes(l));
    }

    public void add(long l) {
        Preconditions.checkArgument(l >= 0L && l <= MAX_REPRESENTABLE_VALUE);
        Tuple2<Integer, Integer> tuple2 = RoaringBitmapArray.decomposeHighLowBytes(l);
        if ((Integer)tuple2._1 >= this.bitmaps.length) {
            this.extendBitmaps((Integer)tuple2._1 + 1);
        }
        RoaringBitmap roaringBitmap = this.bitmaps[(Integer)tuple2._1];
        roaringBitmap.add(((Integer)tuple2._2).intValue());
    }

    private void extendBitmaps(int n) {
        if (this.bitmaps.length == 0 && n == 1) {
            this.bitmaps = new RoaringBitmap[]{new RoaringBitmap()};
            return;
        }
        RoaringBitmap[] roaringBitmapArray = new RoaringBitmap[n];
        System.arraycopy(this.bitmaps, 0, roaringBitmapArray, 0, this.bitmaps.length);
        for (int i = this.bitmaps.length; i < roaringBitmapArray.length; ++i) {
            roaringBitmapArray[i] = new RoaringBitmap();
        }
        this.bitmaps = roaringBitmapArray;
    }

    public static RoaringBitmapArray create(long ... lArray) {
        RoaringBitmapArray roaringBitmapArray = new RoaringBitmapArray();
        for (long l : lArray) {
            roaringBitmapArray.add(l);
        }
        return roaringBitmapArray;
    }

    public long[] toArray() {
        long l = 0L;
        for (RoaringBitmap roaringBitmap : this.bitmaps) {
            l += (long)roaringBitmap.getCardinality();
        }
        Preconditions.checkArgument(l <= Integer.MAX_VALUE, "Cardinality higher than max int value");
        long[] lArray = new long[(int)l];
        int n = 0;
        for (int i = 0; i < this.bitmaps.length; ++i) {
            RoaringBitmap roaringBitmap;
            roaringBitmap = this.bitmaps[i].getIntIterator();
            while (roaringBitmap.hasNext()) {
                int n2 = roaringBitmap.next();
                lArray[n++] = RoaringBitmapArray.composeFromHighLowBytes(i, n2);
            }
        }
        return lArray;
    }

    static class PortableRoaringBitmapArraySerializationFormat {
        static final int MAGIC_NUMBER = 1681511377;

        PortableRoaringBitmapArraySerializationFormat() {
        }

        static RoaringBitmap[] deserialize(ByteBuffer byteBuffer) throws IOException {
            long l = byteBuffer.getLong();
            if (l < 0L) {
                throw new IOException(String.format("Invalid RoaringBitmapArray length (%s < 0)", l));
            }
            if (l > Integer.MAX_VALUE) {
                throw new IOException(String.format("Invalid RoaringBitmapArray length (%s > %s)", l, Integer.MAX_VALUE));
            }
            int n = (int)l;
            ArrayList<RoaringBitmap> arrayList = new ArrayList<RoaringBitmap>(n);
            int n2 = 0;
            for (long i = 0L; i < l; ++i) {
                int n3 = byteBuffer.getInt();
                if ((long)n3 < 0L) {
                    throw new IOException(String.format("Invalid unsigned entry in RoaringBitmapArray (%s)", n3));
                }
                assert (n3 >= n2) : "Keys are required to be sorted in ascending order.";
                while (n2 < n3) {
                    arrayList.add(new RoaringBitmap());
                    ++n2;
                }
                RoaringBitmap roaringBitmap = new RoaringBitmap();
                roaringBitmap.deserialize(byteBuffer);
                arrayList.add(roaringBitmap);
                ++n2;
                byteBuffer.position(byteBuffer.position() + roaringBitmap.serializedSizeInBytes());
            }
            return arrayList.toArray(new RoaringBitmap[0]);
        }
    }

    static class NativeRoaringBitmapArraySerializationFormat {
        static final int MAGIC_NUMBER = 1681511376;

        NativeRoaringBitmapArraySerializationFormat() {
        }

        static RoaringBitmap[] deserialize(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.getInt();
            if (n < 0) {
                throw new IOException(String.format("Invalid RoaringBitmapArray length (%s < 0)", n));
            }
            RoaringBitmap[] roaringBitmapArray = new RoaringBitmap[n];
            for (int i = 0; i < n; ++i) {
                roaringBitmapArray[i] = new RoaringBitmap();
                int n2 = byteBuffer.getInt();
                roaringBitmapArray[i].deserialize(byteBuffer);
                byteBuffer.position(byteBuffer.position() + n2);
            }
            return roaringBitmapArray;
        }
    }
}

