/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Map;
import javax.measure.MetricPrefix;
import javax.measure.Unit;
import org.geotools.measure.Measure;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import si.uom.SI;

public class DefaultTimeCS
extends AbstractCS
implements TimeCS {
    private static final long serialVersionUID = 5222911412381303989L;
    public static final DefaultTimeCS DAYS;
    public static final DefaultTimeCS SECONDS;
    public static final DefaultTimeCS MILLISECONDS;

    public DefaultTimeCS(TimeCS cs) {
        super((CoordinateSystem)cs);
    }

    public DefaultTimeCS(String name, CoordinateSystemAxis axis) {
        super(name, axis);
        DefaultTimeCS.ensureTimeUnit(this.getAxis(0).getUnit());
    }

    public DefaultTimeCS(Map<String, ?> properties, CoordinateSystemAxis axis) {
        super(properties, axis);
        DefaultTimeCS.ensureTimeUnit(this.getAxis(0).getUnit());
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection direction) {
        return AxisDirection.FUTURE.equals((Object)direction.absolute());
    }

    @Override
    protected boolean isCompatibleUnit(AxisDirection direction, Unit<?> unit) {
        return SI.SECOND.isCompatible(unit);
    }

    @Override
    public Measure distance(double[] coord1, double[] coord2) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coord1", coord1);
        this.ensureDimensionMatch("coord2", coord2);
        return new Measure(Math.abs(coord1[0] - coord2[0]), this.getDistanceUnit());
    }

    static {
        Map<String, Object> properties = DefaultTimeCS.name(214);
        DefaultCoordinateSystemAxis axis = DefaultCoordinateSystemAxis.TIME;
        DAYS = new DefaultTimeCS((Map<String, ?>)properties, (CoordinateSystemAxis)axis);
        InternationalString name = ((GenericName)axis.getAlias().iterator().next()).toInternationalString();
        axis = new DefaultCoordinateSystemAxis(name, "t", AxisDirection.FUTURE, SI.SECOND);
        SECONDS = new DefaultTimeCS((Map<String, ?>)properties, (CoordinateSystemAxis)axis);
        axis = new DefaultCoordinateSystemAxis(name, "t", AxisDirection.FUTURE, MetricPrefix.MILLI((Unit)SI.SECOND));
        MILLISECONDS = new DefaultTimeCS((Map<String, ?>)properties, (CoordinateSystemAxis)axis);
    }
}

