/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.common.server;

import com.dataiku.common.server.CountingPrintWriter;
import com.dataiku.common.server.CountingServletOutputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class CountingHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private CountingServletOutputStream countingStream;
    private CountingPrintWriter proxyWriter;
    private PrintWriter writer;

    public CountingHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.countingStream == null) {
            this.countingStream = new CountingServletOutputStream(this.getResponse().getOutputStream());
        }
        return this.countingStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.proxyWriter == null) {
            this.proxyWriter = new CountingPrintWriter(this.getResponse().getWriter());
            this.writer = new PrintWriter((Writer)((Object)this.proxyWriter));
        }
        return this.writer;
    }

    public long getByteCount() {
        if (this.countingStream != null) {
            return this.countingStream.getByteCount();
        }
        if (this.proxyWriter != null) {
            return this.proxyWriter.getByteCount();
        }
        return 0L;
    }
}

