/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.dip.futures.IStateLabelAggregator;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class StateLabelAggregator
implements IStateLabelAggregator {
    private List<String> stateChunks = Lists.newArrayList();

    @Override
    public synchronized Closeable startWaitingOn(final String chunk) {
        this.stateChunks.add(chunk);
        return new Closeable(){

            @Override
            public void close() throws IOException {
                StateLabelAggregator.this.stopWaitingOn(chunk);
            }
        };
    }

    @Override
    public synchronized String makeStateLabel() {
        Collections.sort(this.stateChunks);
        return Joiner.on((String)", ").join(this.stateChunks);
    }

    private synchronized void stopWaitingOn(String chunk) {
        this.stateChunks.remove(chunk);
    }
}

