/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import java.util.Iterator;
import java.util.Random;

public class PortRangeParams {
    public boolean enabled;
    public int start = 1024;
    public int end = 65535;
    public boolean autoSparkConfig;

    public boolean isValid() {
        return this.start >= 1024 && this.end > this.start && this.end <= 65535;
    }

    protected int newStartingPoint() {
        return new Random().nextInt(this.end - this.start + 1) + this.start;
    }

    public Iterable<Integer> getRange() {
        int startingValue = this.newStartingPoint();
        return this.getRange(startingValue);
    }

    public Iterable<Integer> getRange(final int startingValue) {
        assert (this.enabled) : "Can't get range iterable because port range disabled";
        assert (this.isValid()) : "Invalid Port range params";
        return () -> new Iterator<Integer>(){
            int nextValue = -1;

            @Override
            public boolean hasNext() {
                return this.nextValue != startingValue;
            }

            @Override
            public Integer next() {
                int ret;
                block1: {
                    if (this.nextValue == -1) {
                        this.nextValue = startingValue;
                    }
                    if ((ret = this.nextValue++) != PortRangeParams.this.end) break block1;
                    this.nextValue = PortRangeParams.this.start;
                }
                return ret;
            }
        };
    }
}

