/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions;

import com.codahale.metrics.MetricRegistry;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.DebugTransactionRegistry;
import com.dataiku.dip.transactions.TransactionDebugInfo;
import com.dataiku.dip.transactions.fs.AtomicWriter;
import com.dataiku.dip.transactions.fs.FileContentCompressor;
import com.dataiku.dip.transactions.fs.FileContentFactory;
import com.dataiku.dip.transactions.fs.InMemoryFS;
import com.dataiku.dip.transactions.fs.LegacyCache;
import com.dataiku.dip.transactions.fs.MonitoredReadFS;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.ProtectedFiles;
import com.dataiku.dip.transactions.fs.ProxiedReadOnlyFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.CachedReadFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.imfs.InMemoryCache;
import com.dataiku.dip.transactions.fs.imfs.InMemoryCache3;
import com.dataiku.dip.transactions.fs.utils.FSLock;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.CommitQueuesManager;
import com.dataiku.dip.transactions.git.ICommitBehavior;
import com.dataiku.dip.transactions.git.IGitManager;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.impl.CloseShieldTransaction;
import com.dataiku.dip.transactions.impl.RWTransactionImpl;
import com.dataiku.dip.transactions.impl.TransactionImpl;
import com.dataiku.dip.transactions.impl.YOLOTransactionImpl;
import com.dataiku.dip.transactions.utils.ReadWriteUpgradableLock;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class TransactionProvider
implements AutoCloseable {
    public static final String MAIN_FS_LOCK = ".mainlock";
    public static final String WRITE_FS_LOCK = ".wlock";
    private final AtomicWriter atomicFS;
    private final File root;
    private final ProtectedFiles protectedFiles = ProtectedFiles.TRANSACTION_PROTECTED_FILES;
    private final ScheduledExecutorService sched = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("TransactionProvider-%d").setDaemon(true).build());
    private final FSLock writeLock;
    private final CachedReadFS cachedReadFS;
    public final String cacheVersion;
    private final boolean allowPerWriteTransactionCache;
    private final boolean allowPerTransactionCache;
    private volatile ReadWriteUpgradableLock rwLock;
    private CommitQueuesManager commitQueuesManager;
    private FSLock mainLock;
    private final DebugTransactionRegistry debugRegistry;
    private final TransactionProviderSettings settings;
    public static final RelFileFilter GIT_EXCLUSION_FILTER = (fs, file) -> {
        for (String element : file.getElements()) {
            if (!element.equals(".git")) continue;
            return false;
        }
        return true;
    };
    private ThreadLocal<Transaction> currentTransactionTL = new ThreadLocal();
    static final DKULogger logger = DKULogger.getLogger((String)"dip.transactions");

    public DebugTransactionRegistry getDebugRegistry() {
        return this.debugRegistry;
    }

    public IGitManager getGitManager() {
        CommitQueuesManager.ICommitQueuesBehavior commitQueues = this.commitQueuesManager != null ? this.commitQueuesManager.getCommitQueuesBehavior() : null;
        return commitQueues != null ? commitQueues.getGitManager() : null;
    }

    public TransactionProvider(File rootDirectory, TransactionProviderSettings settings) throws IOException {
        this(rootDirectory, settings, new AtomicWriter.NiceInjector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionProvider(File rootDirectory, TransactionProviderSettings settings, AtomicWriter.FailureInjector failureInjector) throws IOException {
        this.settings = settings;
        try {
            this.root = rootDirectory;
            if (settings.isUsingMainExclusiveLock()) {
                this.mainLock = new FSLock(this.root, MAIN_FS_LOCK);
                this.mainLock.acquireLockOfFail();
                File gitIndexLock = new File(new File(this.root, ".git"), "index.lock");
                if (gitIndexLock.isFile()) {
                    logger.warn((Object)"Found a git index.lock file. Assuming improper stop");
                    DKUFileUtils.forceDelete((File)gitIndexLock);
                }
                if (settings.largeFileTempDir != null && settings.largeFileTempDir.isDirectory()) {
                    logger.info((Object)("Cleanup up txn backing store " + String.valueOf(settings.largeFileTempDir)));
                    DKUFileUtils.deleteDirectory((File)settings.largeFileTempDir);
                }
            }
            this.writeLock = new FSLock(this.root, WRITE_FS_LOCK);
            this.writeLock.acquireLockWait();
            try {
                this.atomicFS = new AtomicWriter(this.root, failureInjector, settings.nbWriteThreads, settings.enableCRC32Check);
                if (settings.gitSupport) {
                    this.commitQueuesManager = settings.buildCommitQueuesManager(this.root);
                }
            }
            finally {
                this.writeLock.releaseLock();
            }
            FileContentFactory globalFileContentFactory = new FileContentFactory(null, settings.compressor);
            ReadOnlyFS nativeReadFS = NativeFS.from(this.root).fileContentFactory(globalFileContentFactory).build();
            if (DKUApp.getParams().getBoolParam("dku.core.fs.monitor", false)) {
                nativeReadFS = MonitoredReadFS.build(nativeReadFS, DKULogger.getLogger((String)"FSMonitor"));
            }
            String cacheVersionSetting = DKUApp.getProperty("dku.core.fs.cache", "v3");
            if (settings.forceCacheV1) {
                cacheVersionSetting = "v1";
            }
            switch (cacheVersionSetting) {
                case "v1": {
                    this.cachedReadFS = new LegacyCache(nativeReadFS, GIT_EXCLUSION_FILTER);
                    this.cacheVersion = "v1";
                    break;
                }
                case "v3": {
                    this.cachedReadFS = new InMemoryCache3(nativeReadFS, GIT_EXCLUSION_FILTER, true);
                    this.cacheVersion = "v3";
                    break;
                }
                default: {
                    this.cachedReadFS = new InMemoryCache(nativeReadFS, GIT_EXCLUSION_FILTER, true);
                    this.cacheVersion = "v2";
                }
            }
            this.allowPerTransactionCache = this.cacheVersion.equals("v1") && DKUApp.getParams().getBoolParam("dku.core.fs.allowPerTransactionCache", true);
            this.allowPerWriteTransactionCache = !this.cacheVersion.equals("v3");
            this.rwLock = new ReadWriteUpgradableLock();
            this.debugRegistry = new DebugTransactionRegistry(settings.isUsingMainExclusiveLock(), settings.isUsingMainExclusiveLock());
            if (settings.gitSupport) {
                this.sched.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        ReadWriteUpgradableLock rwLockCopy;
                        if (TransactionProvider.this.commitQueuesManager.hasExpired() && (rwLockCopy = TransactionProvider.this.rwLock) != null) {
                            try (ReadWriteUpgradableLock.WriteLock lh = rwLockCopy.acquireWriteLock();){
                                if (TransactionProvider.this.rwLock == null) {
                                    return;
                                }
                                try {
                                    try {
                                        TransactionProvider.this.writeLock.acquireLockWait();
                                        TransactionProvider.this.commitQueuesManager.commitExpired();
                                    }
                                    finally {
                                        TransactionProvider.this.writeLock.releaseLock();
                                    }
                                }
                                catch (IOException e) {
                                    logger.error((Object)"Unable to asynchronously commit changes to the Git repository", (Throwable)e);
                                }
                            }
                        }
                    }
                }, 100L, 1000L, TimeUnit.MILLISECONDS);
            }
            logger.info((Object)("Transaction provider started (directory=" + String.valueOf(rootDirectory) + ", cache_compression=" + settings.compressor.name() + ", main_lock=" + settings.useMainExclusiveLock + ", temp_dir=" + String.valueOf(settings.largeFileTempDir) + ", fs_cache=" + this.cacheVersion + ", git_support=" + settings.gitSupport + ", per_read_txn_cache=" + this.allowPerTransactionCache + ", per_write_txn_cache=" + this.allowPerWriteTransactionCache + ")"));
        }
        catch (Exception e) {
            logger.error((Object)"Unable to initialize the transaction provider", (Throwable)e);
            if (this.mainLock != null) {
                try {
                    this.mainLock.releaseLock();
                }
                catch (IOException e2) {
                    logger.error((Object)"Cannot release exclusive FS lock", (Throwable)e2);
                }
            }
            if (this.commitQueuesManager != null) {
                this.commitQueuesManager.close();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performDirectCommit(CommitDef def) throws IOException {
        ReadWriteUpgradableLock rwLockCopy = this.rwLock;
        if (rwLockCopy != null) {
            try (ReadWriteUpgradableLock.WriteLock lh = rwLockCopy.acquireWriteLock();){
                if (this.rwLock == null) {
                    return;
                }
                try {
                    this.writeLock.acquireLockWait();
                    this.commitQueuesManager.scheduleOrExecCommit(Lists.newArrayList((Object[])new CommitDef[]{def}), 0L);
                }
                finally {
                    this.writeLock.releaseLock();
                }
            }
        }
    }

    public void flushPendingCommits(String projectKey) throws IOException {
        CommitQueuesManager.ICommitQueuesBehavior commitQueuesBehavior;
        CommitQueuesManager.ICommitQueuesBehavior iCommitQueuesBehavior = commitQueuesBehavior = this.commitQueuesManager != null ? this.commitQueuesManager.getCommitQueuesBehavior() : null;
        if (commitQueuesBehavior != null) {
            commitQueuesBehavior.flushPendingCommits(projectKey);
        }
    }

    public Transaction beginRead(IsolationLevel isolationLevel) {
        return this.beginRead(isolationLevel, null);
    }

    public Transaction beginRead(IsolationLevel isolationLevel, @Nullable String fakeStack) {
        TransactionDebugInfo debugInfo = new TransactionDebugInfo(fakeStack);
        ProxiedReadOnlyFS transaction = switch (isolationLevel) {
            case IsolationLevel.ISOLATED -> {
                CachedReadFS perTxnCache = this.allowPerTransactionCache ? new InMemoryCache(this.cachedReadFS, GIT_EXCLUSION_FILTER, false) : this.cachedReadFS;
                yield new TransactionImpl(this.root, this.debugRegistry, perTxnCache, this.rwLock, debugInfo);
            }
            case IsolationLevel.YOLO -> new YOLOTransactionImpl(this.root, this.debugRegistry, this.cachedReadFS, this.rwLock, debugInfo);
            default -> throw new IllegalArgumentException("Unsupported isolation level: " + String.valueOf((Object)isolationLevel));
        };
        this.currentTransactionTL.set((Transaction)((Object)transaction));
        return transaction;
    }

    public Transaction beginRead() {
        return this.beginRead(IsolationLevel.ISOLATED);
    }

    public Transaction retrieveOrBeginRead() {
        return this.retrieveOrBeginRead(IsolationLevel.ISOLATED);
    }

    public Transaction retrieveOrBeginRead(IsolationLevel isolationLevel) {
        if (this.currentTransactionTL.get() == null || !this.currentTransactionTL.get().isAlive()) {
            return this.beginRead(isolationLevel);
        }
        return new CloseShieldTransaction(this.currentTransactionTL.get(), false);
    }

    @Nullable
    AutoDelete nextTempDir() {
        if (this.settings.largeFileTempDir != null) {
            return new AutoDelete(new File(this.settings.largeFileTempDir, "txn_" + SecretKeyGenerator.generateSmall()));
        }
        return null;
    }

    private FileContentFactory newFileContentFactory() {
        return new FileContentFactory(this::nextTempDir, this.settings.compressor);
    }

    public RWTransaction beginWrite(AuthCtx usr) {
        return this.beginWrite(usr, true);
    }

    public RWTransaction beginWrite(AuthCtx usr, boolean committable) {
        FileContentFactory fileContentFactory = this.newFileContentFactory();
        TransactionDebugInfo debugInfo = new TransactionDebugInfo(null);
        InMemoryFS newGen = new InMemoryFS(this.cachedReadFS, this.allowPerWriteTransactionCache, fileContentFactory);
        newGen.setProtectedFiles(this.protectedFiles);
        RWTransactionImpl transaction = new RWTransactionImpl(this.debugRegistry, this.settings.buildCommitBehavior(), newGen, fileContentFactory, debugInfo, committable);
        ReadWriteUpgradableLock.LockHandle lh = committable ? this.rwLock.acquireUpgradableLock() : this.rwLock.acquireFairReadLock();
        transaction.markStarted(lh, this.atomicFS, this.commitQueuesManager, this.writeLock, this.cachedReadFS, this.root);
        transaction.setUser(usr);
        this.currentTransactionTL.set(transaction);
        return transaction;
    }

    public File getRoot() {
        return this.root;
    }

    public void clearCache() {
        logger.info((Object)"Clearing transaction provider cache");
        this.cachedReadFS.invalidate(RelFile.root());
    }

    public void invalidateCache(RelFile file) {
        logger.info((Object)("Invalidate transaction provider cache for path: " + String.valueOf(file)));
        this.cachedReadFS.invalidate(file);
    }

    public CachedReadFS getCache() {
        return this.cachedReadFS;
    }

    public void registerMetrics(String prefix, MetricRegistry registry) {
        this.cachedReadFS.registerMetrics(prefix + "." + this.cacheVersion, registry);
    }

    @Override
    public void close() throws IOException {
        this.sched.shutdown();
        try (ReadWriteUpgradableLock.WriteLock lh = this.rwLock.acquireWriteLock();){
            this.rwLock = null;
            if (this.mainLock != null) {
                this.mainLock.releaseLock();
                this.mainLock = null;
            }
            if (this.commitQueuesManager != null) {
                this.commitQueuesManager.close();
                this.commitQueuesManager = null;
            }
        }
        this.atomicFS.close();
    }

    public static abstract class TransactionProviderSettings {
        private final boolean useMainExclusiveLock;
        private final boolean forceCacheV1;
        protected final boolean gitSupport;
        private final FileContentCompressor compressor;
        @Nullable
        private final File largeFileTempDir;
        public int nbWriteThreads = 1;
        public boolean enableCRC32Check = true;

        public TransactionProviderSettings(boolean useMainExclusiveLock, boolean forceCacheV1, boolean gitSupport, FileContentCompressor compressor, @Nullable File largeFileTempDir) {
            this.useMainExclusiveLock = useMainExclusiveLock;
            this.forceCacheV1 = forceCacheV1;
            this.gitSupport = gitSupport;
            this.compressor = compressor;
            this.largeFileTempDir = largeFileTempDir;
        }

        public boolean isUsingMainExclusiveLock() {
            return this.useMainExclusiveLock;
        }

        public boolean isForcingCacheV1() {
            return this.forceCacheV1;
        }

        public abstract CommitQueuesManager buildCommitQueuesManager(File var1) throws IOException;

        public abstract ICommitBehavior buildCommitBehavior();
    }

    public static enum TransactionState {
        WAITING_START,
        RUNNING,
        WAITING_UPGRADE,
        COMMITTING;

    }
}

