/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs.imfs;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.dataiku.dip.transactions.fs.ConcreteRelFileAttribute;
import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.Journal;
import com.dataiku.dip.transactions.fs.ReadOnlyFSBase;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.CachedReadFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.utils.AcceptAllFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.output.AppendableWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class InMemoryCache3
extends ReadOnlyFSBase
implements CachedReadFS {
    private final ConcurrentHashMap<RelFile, Node> map = new ConcurrentHashMap();
    private final Node root = new Node(RelFile.root());
    private final StampedLock stampedLock = new StampedLock();
    private final boolean enableInvariantChecks;
    private final boolean negativeCachingEnabled;
    private final LongAdder externalRequestCount = new LongAdder();
    @VisibleForTesting
    final LongAdder internalRequestCount = new LongAdder();
    @VisibleForTesting
    final LongAdder removedNodeCount = new LongAdder();
    private final LongAdder loadSuccessCount = new LongAdder();
    private final LongAdder loadExceptionCount = new LongAdder();
    private ReadOnlyFS base;
    private final RelFileFilter cacheabilityFilter;

    public InMemoryCache3(ReadOnlyFS base) {
        this(base, new AcceptAllFilter(), true);
    }

    public InMemoryCache3(ReadOnlyFS base, RelFileFilter cacheabilityFilter, boolean negativeCachingEnabled) {
        this(base, cacheabilityFilter, negativeCachingEnabled, false);
    }

    public InMemoryCache3(ReadOnlyFS base, RelFileFilter cacheabilityFilter, boolean negativeCachingEnabled, boolean enableInvariantChecks) {
        this.base = base;
        this.cacheabilityFilter = cacheabilityFilter;
        this.negativeCachingEnabled = negativeCachingEnabled;
        this.enableInvariantChecks = enableInvariantChecks;
        this.withWriteLock(() -> {
            this.root.type = RelFileAttribute.FileType.DIRECTORY;
            this.root.attributes = new ConcreteRelFileAttribute(RelFile.root(), RelFileAttribute.FileType.DIRECTORY, -1L, -1L);
            this.map.put(this.root.path, this.root);
        });
    }

    @Override
    public void invalidate(RelFile path) {
        this.withWriteLock(() -> this.invalidateInternal(path));
    }

    private void invalidateInternal(RelFile path) {
        assert (!this.enableInvariantChecks || this.stampedLock.isWriteLocked());
        if (path.isRoot()) {
            this.root.fullListing = null;
            this.root.partialListingHead = null;
            this.removedNodeCount.add(this.map.size());
            this.map.clear();
            this.map.put(this.root.path, this.root);
        } else {
            RelFileAttribute.FileType closestAncestorType;
            Node node = this.map.get(path);
            Node closestAncestor = this.getClosestAncestor(path);
            if (node != null) {
                this.removeNode(closestAncestor, node);
            }
            if ((closestAncestorType = closestAncestor.type) == RelFileAttribute.FileType.DIRECTORY) {
                closestAncestor.fullListing = null;
            } else if (closestAncestorType == RelFileAttribute.FileType.FILE) {
                closestAncestor.content = null;
                closestAncestor.attributes = null;
                closestAncestor.type = null;
            }
        }
    }

    public void setBaseFS(ReadOnlyFS base) {
        this.base = base;
    }

    @Override
    public void updateCache(Journal journal) throws IOException {
        this.withWriteLock(() -> {
            for (RelFile rf : journal.deletedFiles) {
                this.invalidateInternal(rf);
            }
            for (RelFile rf : journal.deletedDirectories) {
                this.invalidateInternal(rf);
            }
            for (RelFile rf : journal.createdDirectories) {
                if (this.cacheabilityFilter.accept(this.base, rf)) {
                    this.ensurePathType(rf, RelFileAttribute.FileType.DIRECTORY);
                    continue;
                }
                this.invalidateInternal(rf);
            }
            for (Journal.WrittenFile wf : journal.getWrittenFiles()) {
                if (this.cacheabilityFilter.accept(this.base, wf.file)) {
                    Node node = this.ensurePathType(wf.file, RelFileAttribute.FileType.FILE);
                    boolean canStoreContent = wf.content != null && !wf.content.isPossiblyNotStoredInMemory();
                    node.content = canStoreContent ? wf.content : null;
                    node.attributes = null;
                    continue;
                }
                this.invalidateInternal(wf.file);
            }
        });
    }

    @Override
    public void inspectionData(Appendable out) throws IOException {
        try (BufferedWriter sb = new BufferedWriter((Writer)new AppendableWriter(out));){
            for (Node node : this.map.values()) {
                FileContent content = node.content;
                RelFile path = node.path;
                RelFileAttribute attributes = node.attributes;
                List<RelFile> fullListing = node.fullListing;
                RelFileAttribute.FileType type = node.type;
                if (type == RelFileAttribute.FileType.FILE) {
                    sb.append("FILE\t");
                    sb.append(path.toString());
                    sb.append("\t");
                    if (content != null) {
                        sb.append(content.inspectionData());
                        sb.append(" ");
                    }
                    sb.append("attrLastModified=");
                    sb.append(attributes == null ? "?" : String.valueOf(attributes.getLastModified()));
                    sb.append(" attrLength=");
                    sb.append(attributes == null ? "?" : String.valueOf(attributes.getLength()));
                } else if (type == RelFileAttribute.FileType.DIRECTORY) {
                    sb.append("DIRECTORY\t");
                    sb.append(path.toString());
                    sb.append("\t");
                    sb.append("fullListing=");
                    sb.append(fullListing == null ? "?" : String.valueOf(fullListing.size()));
                } else {
                    sb.append("UNKNOWN\t");
                    sb.append(path.toString());
                }
                sb.append("\n");
            }
        }
    }

    @Override
    public String fullDumpItem(String path) {
        RelFile rf = RelFile.fromPath(path);
        Node node = this.map.get(rf);
        if (node == null) {
            if (this.determineIfPathCannotPossiblyExist(rf)) {
                return "Cache knows that this path does not exist";
            }
            return "Cache does not contain information about this path";
        }
        FileContent content = node.content;
        if (content != null) {
            return content.fullDumpObject();
        }
        List<RelFile> listing = node.fullListing;
        if (listing != null) {
            return listing.stream().map(RelFile::toString).collect(Collectors.joining("\n"));
        }
        return "Cache knows that this path exists, but does not contain any information about it";
    }

    private Metrics computeMetrics() {
        Metrics metrics = new Metrics();
        metrics.requestCount = this.internalRequestCount.longValue() + this.externalRequestCount.longValue();
        metrics.internalRequestCount = this.internalRequestCount.longValue();
        metrics.externalRequestCount = this.externalRequestCount.longValue();
        metrics.missCount = this.loadExceptionCount.longValue() + this.loadSuccessCount.longValue();
        metrics.loadSuccessCount = this.loadSuccessCount.longValue();
        metrics.loadExceptionCount = this.loadExceptionCount.longValue();
        metrics.hitCount = this.internalRequestCount.longValue() + this.externalRequestCount.longValue() - this.loadExceptionCount.longValue() - this.loadSuccessCount.longValue();
        metrics.hitRate = metrics.requestCount == 0L ? 0.0 : (double)metrics.hitCount / (double)metrics.requestCount;
        for (Node node : this.map.values()) {
            RelFileAttribute attributes = node.attributes;
            FileContent content = node.content;
            List<RelFile> fullListing = node.fullListing;
            RelFileAttribute.FileType type = node.type;
            if (content != null) {
                FileContent.StoredBytesStats stats = content.getBytesStatsIfAvailable();
                metrics.compressedBytes = metrics.compressedBytes + (stats == null ? 0L : stats.compressedLength);
                metrics.uncompressedBytes = metrics.uncompressedBytes + (stats == null ? 0L : stats.uncompressedLength);
                metrics.javaObjectCount = metrics.javaObjectCount + (content.hasObject() ? 1L : 0L);
                ++metrics.fileContentCount;
            }
            metrics.listingCount = metrics.listingCount + (fullListing == null ? 0L : 1L);
            metrics.attributeCount = metrics.attributeCount + (attributes == null ? 0L : 1L);
            metrics.fileNodeCount = metrics.fileNodeCount + (type == RelFileAttribute.FileType.FILE ? 1L : 0L);
            metrics.directoryNodeCount = metrics.directoryNodeCount + (type == RelFileAttribute.FileType.DIRECTORY ? 1L : 0L);
            metrics.untypedNodeCount = metrics.untypedNodeCount + (type == null ? 1L : 0L);
            ++metrics.nodeCount;
        }
        if (metrics.compressedBytes != 0L) {
            metrics.bytesCompressionRatio = (double)metrics.uncompressedBytes / (double)metrics.compressedBytes;
        }
        metrics.removedNodeCount = this.removedNodeCount.longValue();
        metrics.insertedNodeCount = (long)this.map.size() + metrics.removedNodeCount;
        return metrics;
    }

    public Map<String, Metric> getCachedMetrics(int refreshInternalSeconds) {
        CachedGauge<Metrics> cachedMetrics = new CachedGauge<Metrics>((long)refreshInternalSeconds, TimeUnit.SECONDS){

            protected Metrics loadValue() {
                return InMemoryCache3.this.computeMetrics();
            }
        };
        HashMap<String, Metric> metricsMap = new HashMap<String, Metric>();
        for (Field field : Metrics.class.getDeclaredFields()) {
            metricsMap.put(field.getName(), (Metric)((Gauge)() -> InMemoryCache3.lambda$getCachedMetrics$3(field, (CachedGauge)cachedMetrics)));
        }
        return metricsMap;
    }

    @Override
    public void registerMetrics(String name, MetricRegistry registry) {
        registry.register("dku.caches." + name, (Metric)((MetricSet)() -> this.getCachedMetrics(10)));
    }

    @Override
    public List<RelFile> listFiles(RelFile directory) throws IOException {
        return this.listFilesUnordered(directory);
    }

    @Override
    public List<RelFile> listFilesUnordered(RelFile directoryPath) throws IOException {
        this.externalRequestCount.increment();
        Node node = this.map.get(directoryPath);
        if (node != null) {
            List<RelFile> fullListing = node.fullListing;
            if (fullListing != null) {
                return new ArrayList<RelFile>(fullListing);
            }
            RelFileAttribute.FileType nodeType = node.type;
            if (nodeType == RelFileAttribute.FileType.FILE) {
                throw new IOException("Not a directory: " + String.valueOf(directoryPath));
            }
        }
        boolean cacheable = this.cacheabilityFilter.accept(this.base, directoryPath);
        if (node == null && cacheable && this.determineIfPathCannotPossiblyExist(directoryPath)) {
            throw new IOException("Not a directory: " + String.valueOf(directoryPath));
        }
        return new ArrayList<RelFile>(this.listFilesUnorderedFromBaseAndUpdateCache(directoryPath, true, cacheable));
    }

    @VisibleForTesting
    List<RelFile> listFilesUnorderedFromBaseAndUpdateCache(RelFile directoryPath, boolean scanAncestorsOnCacheMiss, boolean cacheable) throws IOException {
        HashSet<RelFile> listingSet;
        List<RelFile> listing;
        try {
            listing = this.base.listFiles(directoryPath);
            for (RelFile childPath : listing) {
                if (directoryPath.isParentOf(childPath)) continue;
                throw new IOException("Invalid directory entry " + String.valueOf(childPath) + " (in " + String.valueOf(directoryPath) + ")");
            }
            listingSet = new HashSet<RelFile>(listing);
            if (listingSet.size() != listing.size()) {
                throw new IOException("Duplicate entries in directory listing");
            }
            this.loadSuccessCount.increment();
        }
        catch (Exception e) {
            this.loadExceptionCount.increment();
            if (this.negativeCachingEnabled && cacheable) {
                this.internalRequestCount.increment();
                this.getAttributesFromBaseAndUpdateCache(directoryPath, scanAncestorsOnCacheMiss, true);
            }
            throw e;
        }
        if (!cacheable) {
            return listing;
        }
        this.withWriteLock(() -> {
            Node dirNode = this.ensurePathType(directoryPath, RelFileAttribute.FileType.DIRECTORY);
            Node childNode = dirNode.partialListingHead;
            while (childNode != null) {
                if (!listingSet.remove(childNode.path)) {
                    this.removeNode(dirNode, childNode);
                }
                childNode = childNode.partialListingNextSibling;
            }
            for (RelFile childPath : listingSet) {
                childNode = new Node(childPath);
                this.insertNode(dirNode, childNode);
            }
            dirNode.fullListing = listing;
        });
        return listing;
    }

    @Override
    public boolean isFile(RelFile path) throws IOException {
        return this.pathHasType(path, RelFileAttribute.FileType.FILE);
    }

    @Override
    public boolean isDirectory(RelFile path) throws IOException {
        return this.pathHasType(path, RelFileAttribute.FileType.DIRECTORY);
    }

    @Override
    public boolean exists(RelFile path) throws IOException {
        return this.pathHasType(path, null);
    }

    private boolean pathHasType(RelFile path, @Nullable RelFileAttribute.FileType testedType) throws IOException {
        this.externalRequestCount.increment();
        Node node = this.map.get(path);
        if (node != null) {
            if (testedType == null) {
                return true;
            }
            RelFileAttribute.FileType nodeType = node.type;
            if (testedType == nodeType) {
                return true;
            }
            if (nodeType != null) {
                return false;
            }
        }
        boolean cacheable = this.cacheabilityFilter.accept(this.base, path);
        if (node == null && cacheable && this.determineIfPathCannotPossiblyExist(path)) {
            return false;
        }
        RelFileAttribute attrs = this.getAttributesFromBaseAndUpdateCache(path, true, cacheable);
        return attrs != null && (testedType == null || attrs.getFileType() == testedType);
    }

    @Override
    public FileContent readContentUnsafe(RelFile path) throws IOException {
        this.externalRequestCount.increment();
        Node node = this.map.get(path);
        if (node != null) {
            FileContent nodeContent = node.content;
            if (nodeContent != null) {
                return nodeContent;
            }
            RelFileAttribute.FileType nodeType = node.type;
            if (nodeType == RelFileAttribute.FileType.DIRECTORY) {
                throw new IOException("Cannot read directory as file: " + String.valueOf(path));
            }
        }
        boolean cacheable = this.cacheabilityFilter.accept(this.base, path);
        if (node == null && cacheable && this.determineIfPathCannotPossiblyExist(path)) {
            throw new IOException("Not a file: " + String.valueOf(path));
        }
        return this.readContentUnsafeFromBaseAndUpdateCache(path, cacheable);
    }

    @VisibleForTesting
    FileContent readContentUnsafeFromBaseAndUpdateCache(RelFile path, boolean cacheable) throws IOException {
        FileContent content;
        try {
            content = this.base.readContentUnsafe(path);
            if (content == null) {
                throw new IOException("File content could not be read: " + String.valueOf(path));
            }
            this.loadSuccessCount.increment();
        }
        catch (Exception e) {
            this.loadExceptionCount.increment();
            if (this.negativeCachingEnabled && cacheable) {
                this.internalRequestCount.increment();
                this.getAttributesFromBaseAndUpdateCache(path, true, true);
            }
            throw e;
        }
        if (!cacheable) {
            return content;
        }
        this.withWriteLock(() -> {
            Node node = this.ensurePathType(path, RelFileAttribute.FileType.FILE);
            node.content = content;
        });
        return content;
    }

    @Override
    @Nullable
    public RelFileAttribute getAttributes(RelFile path) throws IOException {
        RelFileAttribute nodeAttributes;
        this.externalRequestCount.increment();
        Node node = this.map.get(path);
        if (node != null && (nodeAttributes = node.attributes) != null) {
            return nodeAttributes;
        }
        boolean cacheable = this.cacheabilityFilter.accept(this.base, path);
        if (node == null && cacheable && this.determineIfPathCannotPossiblyExist(path)) {
            return null;
        }
        return this.getAttributesFromBaseAndUpdateCache(path, true, cacheable);
    }

    @Nullable
    @VisibleForTesting
    RelFileAttribute getAttributesFromBaseAndUpdateCache(RelFile path, boolean scanAncestorsOnCacheMiss, boolean cacheable) throws IOException {
        RelFileAttribute attrs;
        try {
            attrs = this.base.getAttributes(path);
            if (!(attrs == null || attrs.getFileType() != null && Objects.equals(attrs.getFile(), path))) {
                throw new IOException("Invalid attributes: " + String.valueOf(path));
            }
            this.loadSuccessCount.increment();
        }
        catch (Exception e) {
            this.loadExceptionCount.increment();
            throw e;
        }
        if (!cacheable) {
            return attrs;
        }
        if (attrs == null) {
            this.invalidate(path);
            if (this.negativeCachingEnabled && scanAncestorsOnCacheMiss) {
                this.scanAncestorsToRememberWhyPathDoesNotExist(path);
            }
            return null;
        }
        this.withWriteLock(() -> {
            Node node = this.ensurePathType(path, attrs.getFileType());
            node.attributes = attrs;
        });
        return attrs;
    }

    private void scanAncestorsToRememberWhyPathDoesNotExist(RelFile requestedPath) throws IOException {
        if (requestedPath.isRoot()) {
            return;
        }
        RelFile closestKnownPath = RelFile.root();
        int low = 0;
        int high = requestedPath.length();
        int current = high - 1;
        while (low + 1 < high) {
            RelFile currentPath = requestedPath.subPath(current);
            this.internalRequestCount.increment();
            RelFileAttribute attrs = this.getAttributesFromBaseAndUpdateCache(currentPath, false, true);
            if (attrs == null) {
                high = current;
            } else {
                if (attrs.getFileType() == RelFileAttribute.FileType.FILE) {
                    return;
                }
                low = current;
                closestKnownPath = currentPath;
            }
            current = low + high + 1 >>> 1;
        }
        this.internalRequestCount.increment();
        this.listFilesUnorderedFromBaseAndUpdateCache(closestKnownPath, false, true);
    }

    private boolean determineIfPathCannotPossiblyExist(RelFile path) {
        if (path.isRoot()) {
            return false;
        }
        return this.withOptimisticReadLock(() -> {
            Node closestAncestor = this.getClosestAncestor(path);
            return closestAncestor.type == RelFileAttribute.FileType.FILE || closestAncestor.fullListing != null && this.map.get(path) == null;
        });
    }

    private Node getClosestAncestor(RelFile requestedPath) {
        assert (!requestedPath.isRoot());
        Node closestAncestor = this.root;
        int low = 0;
        int high = requestedPath.length();
        int current = high - 1;
        while (low + 1 < high) {
            Node node = this.map.get(requestedPath.subPath(current));
            if (node == null) {
                high = current;
            } else {
                if (node.type == RelFileAttribute.FileType.FILE) {
                    return node;
                }
                low = current;
                closestAncestor = node;
            }
            current = low + high + 1 >>> 1;
        }
        return closestAncestor;
    }

    private void ensureNodeType(Node node, RelFileAttribute.FileType typeToEnsure) {
        assert (!this.enableInvariantChecks || this.stampedLock.isWriteLocked());
        RelFileAttribute.FileType nodeType = node.type;
        if (nodeType == typeToEnsure) {
            return;
        }
        if (nodeType != null) {
            this.removeNodeDescendants(node);
            node.fullListing = null;
            node.content = null;
        }
        node.attributes = typeToEnsure == RelFileAttribute.FileType.DIRECTORY ? new ConcreteRelFileAttribute(node.path, typeToEnsure, -1L, -1L) : null;
        node.type = typeToEnsure;
    }

    private void insertNode(Node parentNode, Node node) {
        assert (!this.enableInvariantChecks || this.stampedLock.isWriteLocked());
        if (parentNode.partialListingHead != null) {
            parentNode.partialListingHead.partialListingPrevSibling = node;
            node.partialListingNextSibling = parentNode.partialListingHead;
        }
        parentNode.partialListingHead = node;
        this.map.put(node.path, node);
    }

    private void removeNode(Node parentNode, Node node) {
        assert (!this.enableInvariantChecks || this.stampedLock.isWriteLocked());
        this.map.remove(node.path);
        this.removedNodeCount.increment();
        this.removeNodeDescendants(node);
        Node prev = node.partialListingPrevSibling;
        Node next = node.partialListingNextSibling;
        if (prev != null) {
            prev.partialListingNextSibling = next;
        } else {
            parentNode.partialListingHead = next;
        }
        if (next != null) {
            next.partialListingPrevSibling = prev;
        }
    }

    private void removeNodeDescendants(Node node) {
        assert (!this.enableInvariantChecks || this.stampedLock.isWriteLocked());
        Node stack = node.partialListingHead;
        node.partialListingHead = null;
        long removed = 0L;
        while (stack != null) {
            Node current = stack;
            stack = stack.partialListingPrevSibling;
            while (current != null) {
                if (current.partialListingHead != null) {
                    current.partialListingHead.partialListingPrevSibling = stack;
                    stack = current.partialListingHead;
                }
                this.map.remove(current.path);
                current = current.partialListingNextSibling;
                ++removed;
            }
        }
        this.removedNodeCount.add(removed);
    }

    private Node ensurePathType(RelFile path, RelFileAttribute.FileType typeToEnsure) throws IOException {
        assert (!this.enableInvariantChecks || this.stampedLock.isWriteLocked());
        if (path.isRoot()) {
            if (typeToEnsure != RelFileAttribute.FileType.DIRECTORY) {
                throw new IOException("Root is a directory");
            }
            return this.root;
        }
        Node lastNodeCreated = null;
        Node existingNode = null;
        Node requestedNode = null;
        RelFile currentPath = path;
        while (true) {
            boolean isRequestedNode;
            Node currentNode;
            if ((currentNode = this.map.get(currentPath)) == null) {
                currentNode = new Node(currentPath);
                this.map.put(currentPath, currentNode);
                currentNode.partialListingHead = lastNodeCreated;
                lastNodeCreated = currentNode;
            } else {
                existingNode = currentNode;
            }
            boolean bl = isRequestedNode = currentPath == path;
            if (isRequestedNode) {
                requestedNode = currentNode;
            }
            this.ensureNodeType(currentNode, isRequestedNode ? typeToEnsure : RelFileAttribute.FileType.DIRECTORY);
            if (existingNode != null) break;
            currentPath = currentPath.getParent();
        }
        if (lastNodeCreated != null) {
            if (existingNode.partialListingHead != null) {
                existingNode.partialListingHead.partialListingPrevSibling = lastNodeCreated;
                lastNodeCreated.partialListingNextSibling = existingNode.partialListingHead;
            }
            existingNode.partialListingHead = lastNodeCreated;
            existingNode.fullListing = null;
        }
        return requestedNode;
    }

    @VisibleForTesting
    void checkInvariants() {
        Node rootNode = this.map.get(RelFile.root());
        assert (rootNode != null);
        assert (rootNode == this.root);
        assert (rootNode.path.isRoot());
        assert (rootNode.type == RelFileAttribute.FileType.DIRECTORY);
        assert (rootNode.partialListingPrevSibling == null);
        assert (rootNode.partialListingNextSibling == null);
        for (Map.Entry<RelFile, Node> entry : this.map.entrySet()) {
            assert (entry.getKey().equals(entry.getValue().path));
            this.checkInvariants(entry.getValue());
        }
        assert (this.internalRequestCount.longValue() + this.externalRequestCount.longValue() >= this.loadExceptionCount.longValue() + this.loadSuccessCount.longValue());
    }

    private void checkInvariants(Node node) {
        Node childNode;
        assert (node.path != null);
        RelFileAttribute nodeAttributes = node.attributes;
        List<RelFile> nodeFullListing = node.fullListing;
        if (node.partialListingNextSibling != null) {
            Node nextSiblingNode = this.map.get(node.partialListingNextSibling.path);
            assert (nextSiblingNode != null && nextSiblingNode == node.partialListingNextSibling);
            assert (node.path.getParent().equals(nextSiblingNode.path.getParent()));
        }
        if (node.partialListingPrevSibling != null) {
            Node prevSiblingNode = this.map.get(node.partialListingPrevSibling.path);
            assert (prevSiblingNode != null && prevSiblingNode == node.partialListingPrevSibling);
            assert (node.path.getParent().equals(prevSiblingNode.path.getParent()));
        }
        if (node.type == RelFileAttribute.FileType.DIRECTORY) {
            assert (node.content == null);
            ArrayList<RelFile> collectedPartialListing = new ArrayList<RelFile>();
            childNode = node.partialListingHead;
            Node prevChildNode = null;
            while (childNode != null) {
                assert (childNode.partialListingPrevSibling == prevChildNode);
                Node childNodeFromMap = this.map.get(childNode.path);
                assert (childNodeFromMap == childNode);
                assert (childNode.path.getParent().equals(node.path));
                collectedPartialListing.add(childNode.path);
                prevChildNode = childNode;
                childNode = childNode.partialListingNextSibling;
            }
            if (nodeFullListing != null) {
                List sortedPartialListing = Lists.newArrayList(collectedPartialListing).stream().sorted().collect(Collectors.toList());
                assert (Lists.newArrayList(nodeFullListing).equals(sortedPartialListing));
            }
            assert (nodeAttributes != null);
            assert (nodeAttributes.getFileType() == RelFileAttribute.FileType.DIRECTORY);
            assert (nodeAttributes.getFile().equals(node.path));
            assert (nodeAttributes.getLength() == -1L);
            assert (nodeAttributes.getLastModified() == -1L);
        } else if (node.type == RelFileAttribute.FileType.FILE) {
            assert (nodeFullListing == null);
            assert (node.partialListingHead == null);
            if (nodeAttributes != null) {
                assert (nodeAttributes.getLength() != -1L);
                assert (nodeAttributes.getFileType() == RelFileAttribute.FileType.FILE);
                assert (nodeAttributes.getFile().equals(node.path));
            }
        } else if (node.type == null) {
            assert (nodeFullListing == null);
            assert (node.partialListingHead == null);
            assert (node.content == null);
            assert (node.attributes == null);
        } else assert (false);
        if (!node.path.isRoot()) {
            Node parentNode = this.map.get(node.path.getParent());
            assert (parentNode != null);
            childNode = parentNode.partialListingHead;
            while (childNode != null && childNode != node) {
                childNode = childNode.partialListingNextSibling;
            }
            assert (childNode == node);
        }
    }

    private <T> T withOptimisticReadLock(Supplier<T> readOperation) {
        long read = this.stampedLock.tryOptimisticRead();
        try {
            while (true) {
                if (read != 0L) {
                    T result = readOperation.get();
                    if (this.stampedLock.validate(read)) {
                        T t = result;
                        return t;
                    }
                }
                read = this.stampedLock.readLock();
            }
        }
        finally {
            if (StampedLock.isReadLockStamp(read)) {
                this.stampedLock.unlockRead(read);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Exception> void withWriteLock(ExceptionUtils.ThrowingRunnable<E> writeOperation) throws E {
        long write = this.stampedLock.writeLock();
        try {
            writeOperation.run();
        }
        finally {
            if (this.enableInvariantChecks) {
                this.checkInvariants();
            }
            this.stampedLock.unlockWrite(write);
        }
    }

    private static /* synthetic */ Number lambda$getCachedMetrics$3(Field field, CachedGauge cachedMetrics) {
        try {
            return (Number)field.get(cachedMetrics.getValue());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Node {
        @Nullable
        volatile RelFileAttribute.FileType type;
        @Nullable
        volatile List<RelFile> fullListing;
        @Nullable
        volatile FileContent content;
        @Nullable
        volatile RelFileAttribute attributes;
        final RelFile path;
        @Nullable
        Node partialListingHead;
        @Nullable
        Node partialListingNextSibling;
        @Nullable
        Node partialListingPrevSibling;

        Node(RelFile path) {
            this.path = path;
        }
    }

    private static class Metrics {
        long requestCount;
        long internalRequestCount;
        long externalRequestCount;
        long missCount;
        long loadSuccessCount;
        long loadExceptionCount;
        long hitCount;
        double hitRate;
        long compressedBytes;
        long uncompressedBytes;
        long javaObjectCount;
        long fileContentCount;
        long listingCount;
        long attributeCount;
        long fileNodeCount;
        long directoryNodeCount;
        long untypedNodeCount;
        long nodeCount;
        double bytesCompressionRatio;
        long removedNodeCount;
        long insertedNodeCount;

        private Metrics() {
        }
    }
}

