/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.utils;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class ReadWriteUpgradableLock {
    private static final int maxPermits = Short.MAX_VALUE;
    private final Semaphore upgradeMutex = new Semaphore(1, true);
    private final Semaphore fairReaderSemaphore = new Semaphore(Short.MAX_VALUE, true);
    private final Semaphore unfairReaderSemaphore = new Semaphore(Short.MAX_VALUE, false);

    public ReadLock acquireFairReadLock() {
        return new ReadLock(true);
    }

    public ReadLock acquireUnfairReadLock() {
        return new ReadLock(false);
    }

    public WriteLock acquireWriteLock() {
        return new WriteLock();
    }

    public UpgradableLock acquireUpgradableLock() {
        return new UpgradableLock();
    }

    public class ReadLock
    implements LockHandle {
        private final boolean fair;
        private final AtomicInteger acquiredReaders = new AtomicInteger();

        public ReadLock(boolean fair) {
            this.fair = fair;
            if (fair) {
                ReadWriteUpgradableLock.this.fairReaderSemaphore.acquireUninterruptibly(1);
            }
            ReadWriteUpgradableLock.this.unfairReaderSemaphore.acquireUninterruptibly(1);
            this.acquiredReaders.set(1);
        }

        @Override
        public void close() {
            if (this.acquiredReaders.compareAndSet(1, 0)) {
                if (this.fair) {
                    ReadWriteUpgradableLock.this.fairReaderSemaphore.release(1);
                }
                ReadWriteUpgradableLock.this.unfairReaderSemaphore.release(1);
            }
        }
    }

    public class WriteLock
    implements LockHandle {
        private final UpgradableLock upgradableLock;

        public WriteLock() {
            this.upgradableLock = new UpgradableLock();
            this.upgradableLock.upgrade();
        }

        @Override
        public void close() {
            this.upgradableLock.close();
        }
    }

    public class UpgradableLock
    implements LockHandle {
        private int acquiredReaders;
        private boolean released;

        public UpgradableLock() {
            ReadWriteUpgradableLock.this.upgradeMutex.acquireUninterruptibly(1);
        }

        public synchronized void upgrade() {
            if (this.acquiredReaders == 0) {
                ReadWriteUpgradableLock.this.fairReaderSemaphore.acquireUninterruptibly(Short.MAX_VALUE);
                ReadWriteUpgradableLock.this.unfairReaderSemaphore.acquireUninterruptibly(Short.MAX_VALUE);
                this.acquiredReaders = Short.MAX_VALUE;
            }
        }

        @Override
        public synchronized void close() {
            if (!this.released) {
                ReadWriteUpgradableLock.this.fairReaderSemaphore.release(this.acquiredReaders);
                ReadWriteUpgradableLock.this.unfairReaderSemaphore.release(this.acquiredReaders);
                ReadWriteUpgradableLock.this.upgradeMutex.release(1);
                this.released = true;
            }
        }
    }

    public static interface LockHandle
    extends AutoCloseable {
        @Override
        public void close();
    }
}

