/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.DatasetCopier;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchIndex;
import com.dataiku.dip.datasets.elasticsearch.InteractiveSearchService;
import com.dataiku.dip.datasets.fs.UploadedFilesDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.ComputeResourceUsageTicketUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetReadAPIUtils;
import com.dataiku.dip.server.datasets.FileUploadService;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.DatasetStreamService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/datasets"})
public class PublicAPIDatasetsDataController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetDeletionService deletionService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private FileUploadService fileUploadService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private DatasetStreamService datasetStreamService;
    @Autowired
    private InteractiveSearchService interactiveSearchService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.api.datasets");

    @AuditedCall(value={"msgType", "dataset-read-data", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/data"}, method={RequestMethod.GET})
    public void getData(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam(value="format", defaultValue="json") String format, @RequestParam(value="formatParams", defaultValue="") String formatParams, @RequestParam(value="sampling", defaultValue="") String sampling, @RequestParam(value="columns", defaultValue="") String columns, @RequestParam(value="partitions", defaultValue="") String partitions, @RequestParam(value="filter", defaultValue="") String filterExpression, @RequestParam(required=false) String readSessionId) throws Exception {
        AuthCtx authCtx;
        Dataset dataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
            AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);
            authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_DATA});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback((HttpServletRequest)req, (AuthCtxUsage)authCtxUsage, u -> ComputeResourceUsageContext.forReadData((AuthCtx)u, (String)projectKey, (String)datasetName));
        }
        this.datasetStreamService.doStream(resp, authCtx, dataset, format, DatasetReadAPIUtils.formatParamsFromString((String)formatParams), DatasetReadAPIUtils.columnsListFromString((String)columns), partitions, filterExpression, DatasetReadAPIUtils.samplingParamFromString((String)sampling), readSessionId);
    }

    @AuditedCall(value={"msgType", "dataset-read-data", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/data"}, method={RequestMethod.POST})
    public void getData2(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        AuthCtx authCtx;
        DatasetReadAPIUtils.DatasetStreamingRequestSettings settings = (DatasetReadAPIUtils.DatasetStreamingRequestSettings)this.getRequestBodyAs(req, DatasetReadAPIUtils.DatasetStreamingRequestSettings.class);
        Dataset dataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
            AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);
            authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_DATA});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback((HttpServletRequest)req, (AuthCtxUsage)authCtxUsage, u -> ComputeResourceUsageContext.forReadData((AuthCtx)u, (String)projectKey, (String)datasetName));
        }
        this.datasetStreamService.doStream(resp, authCtx, dataset, settings.format, settings.formatParams, settings.columns, settings.partitions, settings.filterExpression, settings.sampling, settings.readSessionId);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/{datasetName}/finish-streaming"}, method={RequestMethod.GET})
    public void finishStreaming(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam String readSessionId) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_DATA});
        }
        this.datasetStreamService.verifyRead(readSessionId);
        resp.setStatus(200);
    }

    @AuditedCall(value={"msgType", "dataset-clear-data", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/data"}, method={RequestMethod.DELETE})
    public void clear(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam(defaultValue="") String partitions) throws Exception {
        AuthCtx authCtx;
        Dataset ds = null;
        try (Transaction t = this.transactionService.beginRead();){
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart((String)projectKey, (String)datasetName);
            AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);
            authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.WRITE_DATA});
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback((HttpServletRequest)req, (AuthCtxUsage)authCtxUsage, u -> ComputeResourceUsageContext.forDatasetClearing((AuthCtx)u, (String)projectKey, (String)datasetName));
        }
        if (StringUtils.isNotBlank((String)partitions)) {
            ArrayList<String> pids = new ArrayList<String>();
            for (Partition partition : PartitionFactory.fromPartitionSpec((PartitioningScheme)ds.getPartitioningSchema(), (String)partitions)) {
                pids.add(partition.id());
            }
            PublicAPIDatasetsDataController.writeJSON((HttpServletResponse)resp, (Object)this.deletionService.clearPartitions_NT(authCtx, ds, pids));
        } else {
            PublicAPIDatasetsDataController.writeJSON((HttpServletResponse)resp, (Object)this.deletionService.clearDatasetData_NT(authCtx, ds, true, true));
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-meta", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/partitions"}, method={RequestMethod.GET})
    public void listPartitions(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        AuthCtx authCtx;
        ArrayList<String> partitionNames = new ArrayList<String>();
        Dataset ds = null;
        try (Transaction t = this.transactionService.beginRead();){
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart((String)projectKey, (String)datasetName);
            AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);
            authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_DATA});
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback((HttpServletRequest)req, (AuthCtxUsage)authCtxUsage, u -> ComputeResourceUsageContext.forReadData((AuthCtx)u, (String)projectKey, (String)datasetName));
        }
        try (DatasetHandler dh = DatasetHandlerFactory.build((AuthCtx)authCtx, (Dataset)ds);){
            for (Partition p : dh.listPartitions()) {
                partitionNames.add(p.id());
            }
        }
        PublicAPIDatasetsDataController.writeJSON((HttpServletResponse)resp, partitionNames);
    }

    @AuditInline
    @RequestMapping(value={"/{datasetName}/uploaded/files"}, method={RequestMethod.POST})
    public void uploadedAddFile(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam MultipartFile file) throws Exception {
        Dataset dataset;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDatasetPrivileges(authCtx, new DatasetLocUtils.DatasetLoc(projectKey, datasetName), new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.WRITE_DATA});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            if (dataset.getParams().getConnection() != null) {
                this.connectionsService.checkUserForConnection(authCtx, dataset.getParams().getConnection());
            }
            if (!dataset.getType().equals("UploadedFiles")) {
                throw ErrorContext.iaef((String)"Dataset type (%s) does not allow uploaded files", (Object)dataset.getType(), (Object[])new Object[0]);
            }
        }
        this.deletionService.clearCache_NT(dataset);
        try (UploadedFilesDatasetHandler dh = (UploadedFilesDatasetHandler)DatasetHandlerFactory.build((AuthCtx)authCtx, (Dataset)dataset);){
            logger.info((Object)("Uploading file " + file.getOriginalFilename() + " to dataset " + dataset.getName()));
            this.fileUploadService.addFileToDataset(authCtx, dh, file.getInputStream(), file.getOriginalFilename());
        }
        this.auditTrailService.generic("dataset-upload-add-file").with("projectKey", projectKey).with("datasetName", dataset.getName()).with("filename", file.getOriginalFilename()).emit();
    }

    @AuditedCall(value={"msgType", "dataset-upload-list-files", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/uploaded/files"}, method={RequestMethod.GET})
    public void uploadedListFiles(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        List files;
        Dataset dataset;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDatasetPrivileges(authCtx, new DatasetLocUtils.DatasetLoc(projectKey, datasetName), new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_DATA});
            dataset = this.datasetAccessService.getMandatoryUnsafe(projectKey, datasetName);
        }
        if (!dataset.getType().equals("UploadedFiles")) {
            throw ErrorContext.iaef((String)"Dataset type (%s) does not allow uploaded files", (Object)dataset.getType(), (Object[])new Object[0]);
        }
        try (UploadedFilesDatasetHandler dh = (UploadedFilesDatasetHandler)DatasetHandlerFactory.build((AuthCtx)authCtx, (Dataset)dataset);){
            files = this.fileUploadService.listFilesInDataset(dh);
        }
        Collections.sort(files, new Comparator<FileUploadService.UploadedFile>(){

            @Override
            public int compare(FileUploadService.UploadedFile a, FileUploadService.UploadedFile b) {
                return a.path.compareTo(b.path);
            }
        });
        PublicAPIDatasetsDataController.writeJSON((HttpServletResponse)resp, (Object)files);
    }

    @AuditedCall(value={"msgType", "dataset-copy", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/actions/copyTo"}, method={RequestMethod.POST})
    public void copyTo(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        DSSAuthCtx authCtx;
        DatasetCopyRequest dcr = (DatasetCopyRequest)this.getRequestBodyAs(req, DatasetCopyRequest.class);
        DatasetLocUtils.DatasetLoc sourceLoc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
        DatasetLocUtils.DatasetLoc targetLoc = new DatasetLocUtils.DatasetLoc(dcr.targetProjectKey, dcr.targetDatasetName);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);
            authCtx = (DSSAuthCtx)authCtxUsage.getAuthCtx();
            this.permissionsService.checkDatasetPrivileges((AuthCtx)authCtx, sourceLoc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_DATA});
            this.permissionsService.checkDatasetPrivileges((AuthCtx)authCtx, targetLoc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.WRITE_DATA});
            Dataset source = this.datasetAccessService.getMandatoryUnsafe(projectKey, datasetName);
            Dataset target = this.datasetAccessService.getMandatoryUnsafe(dcr.targetProjectKey, dcr.targetDatasetName);
            if (source.getPartitioningSchema().isPartitioned()) {
                throw ErrorContext.iaef((String)"Dataset %s is partitioned, this is not supported for the copy API", (Object)sourceLoc.toString(), (Object[])new Object[0]);
            }
            if (target.getPartitioningSchema().isPartitioned()) {
                throw ErrorContext.iaef((String)"Dataset %s is partitioned, this is not supported for the copy API", (Object)targetLoc.toString(), (Object[])new Object[0]);
            }
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback((HttpServletRequest)req, (AuthCtxUsage)authCtxUsage, u -> ComputeResourceUsageContext.forReadData((AuthCtx)u, (String)projectKey, (String)datasetName));
        }
        DatasetCopier copier = new DatasetCopier();
        PublicAPIDatasetsDataController.writeJSON((HttpServletResponse)resp, (Object)copier.startCopy_NT(authCtx, (AnyLoc)sourceLoc, (AnyLoc)targetLoc, dcr.syncSchema, dcr.writeMode));
    }

    @AuditedCall(value={"msgType", "dataset-get-full-info", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/info"}, method={RequestMethod.GET})
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        AuthCtx authCtx;
        DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_DATA});
        }
        NavigatorService.DatasetFullInfo info = this.navigatorService.getDatasetFullInfo_NT((AnyLoc)loc, projectKey, authCtx);
        PublicAPIDatasetsDataController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "dataset-search-data-elastic", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/search-data-elastic"}, method={RequestMethod.GET})
    public void searchData(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam String queryString, @RequestParam(required=false, defaultValue="0") int start, @RequestParam(required=false, defaultValue="128") Integer size, @RequestParam(required=false) List<ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery.SortParameter> sortColumns, @RequestParam(required=false) List<String> partitions) throws Exception {
        Dataset dataset = null;
        DSSAuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkDatasetPrivileges((AuthCtx)authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_DATA});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        if (!DatasetInspector.isElasticSearch((SerializedDataset)dataset.serialize())) {
            throw new IllegalArgumentException(datasetName + " is not an Elasticsearch dataset");
        }
        ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery paginatedInteractiveSearchQuery = new ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery();
        paginatedInteractiveSearchQuery.queryString = queryString;
        paginatedInteractiveSearchQuery.from = start;
        paginatedInteractiveSearchQuery.size = size;
        paginatedInteractiveSearchQuery.sortParameters = sortColumns;
        paginatedInteractiveSearchQuery.datasetSelection = new DatasetSelection();
        if (partitions != null && !partitions.isEmpty()) {
            paginatedInteractiveSearchQuery.datasetSelection.selectedPartitions = partitions;
            paginatedInteractiveSearchQuery.datasetSelection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.SELECTED;
        }
        PublicAPIDatasetsDataController.writeJSON((HttpServletResponse)resp, (Object)this.interactiveSearchService.startPublicAPISearchFuture(authCtx, dataset, paginatedInteractiveSearchQuery));
    }

    static class DatasetCopyRequest {
        public String targetProjectKey;
        public String targetDatasetName;
        public boolean syncSchema;
        public Output.WriteMode writeMode = Output.WriteMode.OVERWRITE;

        DatasetCopyRequest() {
        }
    }
}

