/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.datasets;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.meanings.MeaningsService;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/publicapi/meanings"})
public class PublicAPIMeaningsCRUDController
extends PublicAPIControllerBase {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private MeaningsService meaningsService;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.meanings");

    @AuditedCall(value={"msgType", "meanings-list"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getTicketOrKey(req);
            List meanings = this.meaningsService.listUserDefinedUnsafe();
            PublicAPIMeaningsCRUDController.writeJSON((HttpServletResponse)resp, (Object)meanings);
        }
    }

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void add(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        UserDefinedMeaning udm = (UserDefinedMeaning)this.getRequestBodyAs(req, UserDefinedMeaning.class);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            this.meaningsService.create(udm);
            t.commit("Created user-defined meaning: " + udm.id);
        }
        this.auditTrailService.generic("meaning-create").with("meaningId", udm.id).emit();
        this.writeMessage(resp, "Created meaning %s", new Object[]{udm.id});
    }

    @AuditedCall(value={"msgType", "meaning-get", "meaningId", "${meaningId}"})
    @RequestMapping(value={"/{meaningId:.+}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String meaningId) throws Exception {
        UserDefinedMeaning udm;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getTicketOrKey(req);
            udm = this.getMeaningMandatory(meaningId);
        }
        PublicAPIMeaningsCRUDController.writeJSON((HttpServletResponse)resp, (Object)udm);
    }

    @AuditedCall(value={"msgType", "meaning-save", "meaningId", "${meaningId}"})
    @RequestMapping(value={"/{meaningId:.+}"}, method={RequestMethod.PUT})
    public void update(HttpServletRequest req, HttpServletResponse resp, @PathVariable String meaningId) throws Exception {
        UserDefinedMeaning udm = (UserDefinedMeaning)this.getRequestBodyAs(req, UserDefinedMeaning.class);
        this.require(meaningId.equals(udm.id), "Meaning id does not match the requested URL");
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            if (this.meaningsService.getUnsafe(meaningId) == null) {
                throw new DKUControllerBase.MalformedRequestException("Meaning '" + meaningId + "' does not exist");
            }
            this.meaningsService.save(udm);
            t.commit("Updated user-defined meaning: " + udm.id);
        }
        this.writeMessage(resp, "Updated meaning %s", new Object[]{udm.id});
    }

    private UserDefinedMeaning getMeaningMandatory(String meaningId) throws IOException, NotFoundException {
        UserDefinedMeaning udm = this.meaningsService.getUnsafe(meaningId);
        if (udm == null) {
            throw new NotFoundException("Meaning '" + meaningId + "' does not exist.");
        }
        return udm;
    }
}

