/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.S3Storage;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.StaxUnmarshallerContext;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class S3StorageStaxUnmarshaller
implements Unmarshaller<S3Storage, StaxUnmarshallerContext> {
    private static S3StorageStaxUnmarshaller instance;

    @Override
    public S3Storage unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3Storage s3Storage = new S3Storage();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3Storage;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AWSAccessKeyId", targetDepth)) {
                    s3Storage.setAWSAccessKeyId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("bucket", targetDepth)) {
                    s3Storage.setBucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("prefix", targetDepth)) {
                    s3Storage.setPrefix(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("uploadPolicy", targetDepth)) {
                    s3Storage.setUploadPolicy(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("uploadPolicySignature", targetDepth)) continue;
                s3Storage.setUploadPolicySignature(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3Storage;
    }

    public static S3StorageStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3StorageStaxUnmarshaller();
        }
        return instance;
    }
}

