(function() {
    'use strict';
	const app = angular.module('dataiku.recipes');

    // Creation modal controller
    app.controller("ExtractFailedRowsRecipeCreationController", function($scope, $controller) {
        $scope.recipeType = "extract_failed_rows";
        $scope.datasetsOnly = true;
        $scope.inputDatasetsOnly = true;
        $controller("SingleOutputDatasetRecipeCreationController", {$scope:$scope});

        $scope.autosetName = function() {
            if ($scope.io.inputDataset) {
                const niceInputName = $scope.io.inputDataset.replace(/[A-Z]*\./,"");
                $scope.maybeSetNewDatasetName(niceInputName + "_failed_rows");
            }
        };
    });

    app.controller("ExtractFailedRowsRecipeController", function($scope, $stateParams, $q, $timeout, DKUtils, Logger, $controller, DatasetUtils, translate, ActivityIndicator) {
        const visualCtrl = $controller('VisualRecipeEditorController', {$scope: $scope}); //Controller inheritance
        this.visualCtrl = visualCtrl;

        const contextProjectKey = $scope.context && $scope.context.projectKey ? $scope.context.projectKey:$stateParams.projectKey;

        $scope.hooks.getPayloadData = function () {
            return angular.toJson($scope.params);
        };

        $scope.hooks.updateRecipeStatus = function(forceUpdate, exactPlan) {
            const payload = $scope.hooks.getPayloadData();
            if (!payload) return $q.reject("payload not ready");
            const deferred = $q.defer();
            $scope.updateRecipeStatusBase(forceUpdate, payload, {reallyNeedsExecutionPlan: exactPlan, exactPlan: exactPlan}).then(function() {
                // $scope.recipeStatus should have been set by updateRecipeStatusBase
                if (!$scope.recipeStatus) {
                    return deferred.reject();
                }

                const outputSchema = $scope.recipeStatus.outputSchema;
                const outputSchemaBO = $scope.recipeStatus.outputSchemaBeforeOverride;
                if (outputSchema) {
                    $scope.params.outputColumnNameOverrides = $scope.params.outputColumnNameOverrides || {};
                    const columnsAO = outputSchema.columns; // after override
                    const columnsBO = (outputSchemaBO && outputSchemaBO.columns) ? outputSchemaBO.columns : outputSchema.columns; // before override

                    for (const i in columnsAO) {
                        if (columnsAO[i].name != columnsBO[i].name) {
                            $scope.params.outputColumnNameOverrides[columnsBO[i].name] = columnsAO[i].name;
                        }
                        columnsAO[i].$beforeOverride = columnsBO[i].name;
                        columnsAO[i].name = $scope.params.outputColumnNameOverrides[columnsBO[i].name] || columnsBO[i].name;
                    }
                }

                $scope.uiState.columnRules = angular.copy($scope.recipeStatus.consolidatedColumnRules);;

                if (!angular.equals($scope.params.columnRules, $scope.getParamsColumnRulesFromUiStateColumnRules())) {
                    ActivityIndicator.success(translate("EXTRACT_FAILED_ROWS_RECIPE.STEPS.RULES.RULES_AUTO_FIXED", "Recipe configuration has been updated to reflect changes on the dataset Data Quality rules"), 5000);
                }

                deferred.resolve($scope.recipeStatus);
            });
            return deferred.promise;
        };

        /********  general init  ********/

        function loadParamsFromScript(scriptData) {
            if (!scriptData) {
                return;
            }
            $scope.params = JSON.parse(scriptData);
            $scope.params.outputColumnNameOverrides = $scope.params.outputColumnNameOverrides || {};

            $scope.uiState.selectAllValidRules = !$scope.params.explicitColumnSelection;

            //keep params for dirtiness detection
            visualCtrl.saveServerParams();

            // update recipe according to current schema
            resyncWithInputSchema();
        }

        function resyncWithInputSchema() {
            // remove outdated columns (keep computed columns or column that is in the schema)
            $scope.params = $scope.params || {};

            // call the callback if it exists
            if ($scope.onResyncWithInputSchema) {
                $scope.onResyncWithInputSchema();
            }
        }

        function onScriptChanged(nv, ov) {
             if (nv) {
                loadParamsFromScript($scope.script.data);
                DKUtils.reflowNext();
                DKUtils.reflowLater();
                $scope.hooks.updateRecipeStatus();
            }
        }

        $scope.uiState = {
            currentStep: 'rules',
            outputColumnNamesOverridable: true,
            columnRules: [],
            selectAllValidRules: true,
        };

        /******  rules  *****/
        $scope.selectAllColumnRules = function() {
            $scope.uiState.columnRules.forEach(desc => {
                if (!desc.isSelected && desc.isSupported) {
                    desc.isSelected = true;
                }
            });
        }

        /******  overrides  *****/
        $scope.updateColumnNameOverride = function(column) {
            if (column.$beforeOverride != column.name) {
                $scope.params.outputColumnNameOverrides[column.$beforeOverride] = column.name;
            } else {
                delete $scope.params.outputColumnNameOverrides[column.$beforeOverride];
            }
        };

        $scope.hooks.onRecipeLoaded = function(){
            Logger.info("On Recipe Loaded");
            $scope.$watch("script.data", onScriptChanged, true); // this will call $scope.hooks.updateRecipeStatus when ready
            $scope.$watchCollection("recipe.inputs.main.items", function() {
                DatasetUtils.updateRecipeComputables($scope, $scope.recipe, $stateParams.projectKey, contextProjectKey)
                    .then(_ => resyncWithInputSchema());
            });
        };

        $scope.$watch('topNav.tab',function(nv){
            if (nv == 'settings') {
                $timeout(function() {
                    $scope.$broadcast('redrawFatTable');
                });
            }
        });

        $scope.getParamsColumnRulesFromUiStateColumnRules = function() {
            return $scope.uiState.columnRules.map(uiDesc => {
                // !!! Keep this aligned with definition of ColumnRuleDesc in ExtractFailedRowsRecipePayloadParams.java
                return {
                    ruleId: uiDesc.ruleId,
                    ruleColumn: uiDesc.ruleColumn,
                    isSelected: uiDesc.isSelected,
                };
            });
        }

        $scope.$watch("uiState.columnRules", (columnRules) => {
            if(!$scope.params) {
                return;
            }
            const numSelectedRules = $scope.uiState.columnRules.filter(desc => desc.isSelected).length;
            const numTotalRules = $scope.uiState.columnRules.length;
            $scope.ruleCounters = translate("EXTRACT_FAILED_ROWS_RECIPE.STEPS.RULES.TO_BE_EXTRACTED", "{{numSelectedRules}} / {{numTotalRules}} {{numSelectedRules == 1 ? 'rule' : 'rules'}} to be extracted", {"numSelectedRules": numSelectedRules, "numTotalRules": numTotalRules});

            $scope.params.columnRules = $scope.getParamsColumnRulesFromUiStateColumnRules();

            $scope.updateRecipeStatusLater();
        }, true);

        $scope.$watch("uiState.selectAllValidRules", () => {
            if(!$scope.params) {
                return;
            }

            $scope.params.explicitColumnSelection = !$scope.uiState.selectAllValidRules;

            $scope.updateRecipeStatusLater();
        });

        $scope.enableAutoFixup();
        $scope.specificControllerLoadedDeferred.resolve();
    });
})();
