import time

from dataiku.llm.python import BaseLLM


class MyLLM(BaseLLM):
    def process_stream(self, query, settings, trace):
        prompt = query["messages"][-1]["content"]

        yield {
            "chunk": {
                "text" : "Hello, I'm a synchronous agent with streaming support\n"
            }
        }
        time.sleep(1)
        yield {
            "chunk": {
                "text" : "You asked me: %s\n" % prompt
            }
        }
        time.sleep(1)
        yield {
            "chunk": {
                "text" : "I should think about how to respond\n"
            }
        }
