#!/bin/bash
# wrapper to ignore parasite additional arguments passed by some infrastructure providers

DATA_DIR="/home/dataiku/data"

export ALLOW_DSS_TO_RUN_AS_ROOT=1
export DKU_APINODE_FAIL_IF_START_ABORTED=1

# Regenerate config to take install.ini into account
DKU_DSSADMIN_NO_CHMOD_SUPERVISORD=1 "${DATA_DIR}/bin/dssadmin" regenerate-config

echo "************ STARTING ************************"
"${DATA_DIR}/bin/dss" run
RETCODE=$?
echo "DSS Stopped! With return code $RETCODE. Probably apimain crashed"
echo "apimain log:"
echo "------------"
cat "$DATA_DIR/run/apimain.log"

echo "DSS stopped with code $RETCODE" > /dev/termination-log

